/*
 * Decompiled with CFR 0.152.
 */
package ecoSim.properties;

import ecoSim.properties.UnavailablePropertyException;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class PropertiesStore {
    private static final String CONFIGURATION_FILE = "ecosim-properties";
    private static PropertiesStore instance;
    private static HashMap<Object, Object> properties;

    private PropertiesStore() {
        try {
            Class<PropertiesStore> almacenPropiedadesClass = PropertiesStore.class;
            FileInputStream f = new FileInputStream("prop/ecosim-properties");
            Properties propiedadesTemporales = new Properties();
            propiedadesTemporales.load(f);
            ((InputStream)f).close();
            properties = new HashMap<Object, Object>(propiedadesTemporales);
        }
        catch (Exception e) {
            System.err.println("Some exception!");
        }
    }

    public static PropertiesStore getInstance() {
        if (instance == null) {
            instance = new PropertiesStore();
        }
        return instance;
    }

    public String getProperty(String name) throws UnavailablePropertyException {
        String valor = (String)properties.get(name);
        if (valor == null) {
            throw new UnavailablePropertyException(name);
        }
        return valor;
    }

    public void setProperty(String name, String value) {
        properties.put(name, value);
    }

    public void saveProperties() {
        this.saveProperties(CONFIGURATION_FILE);
    }

    public void saveProperties(String fileName) {
        Properties prop = new Properties();
        prop.putAll((Map<?, ?>)properties);
        try {
            prop.store(new FileOutputStream("prop/" + fileName), "Updated: " + new Date());
            instance = new PropertiesStore();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void saveProperties(String fileName, LinkedHashMap<Object, Object> fromProps) {
        try {
            BufferedWriter bw = new BufferedWriter(new FileWriter("prop/" + fileName));
            Set<Map.Entry<Object, Object>> entries = fromProps.entrySet();
            for (Map.Entry<Object, Object> e : entries) {
                Object key = e.getKey();
                Object value = e.getValue();
                bw.write(key + " = " + value + "\n");
            }
            bw.close();
        }
        catch (FileNotFoundException e1) {
            e1.printStackTrace();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
    }
}

