/*
 * Decompiled with CFR 0.152.
 */
package ecoSim.parameterParser;

import ecoSim.parameterParser.IParameterParserInputData;
import ecoSim.parameterParser.ParameterParser;
import ecoSim.parameterParser.ParameterParserException;
import ecoSim.parameterParser.ParseException;
import ecoSim.parameterParser.VoidRangeException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class Parameter {
    private String name;
    private List<String> indexes;
    private String value;
    private int sec;
    private IParameterParserInputData inputData;
    private Map<String, Number> parameters;
    private Map<String, Number> currentParameters;

    public Parameter(String name) {
        this.name = name = name.replaceAll(" ", "");
        this.indexes = new ArrayList<String>();
        this.parameters = new LinkedHashMap<String, Number>();
        this.currentParameters = new LinkedHashMap<String, Number>();
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value.replaceAll(" ", "");
    }

    public int getSec() {
        return this.sec;
    }

    public void setSec(int sec) {
        this.sec = sec;
    }

    public String getName() {
        return this.name;
    }

    public List<String> getIndexes() {
        return this.indexes;
    }

    private void generatePlinguaParametersRec(int index, int[] indexesValues, Map<String, Number> pLinguaParameters) throws ParameterParserException {
        if (index == this.indexes.size()) {
            String name = this.name;
            if (indexesValues != null) {
                name = String.valueOf(name) + "{";
                int i = 0;
                while (i < indexesValues.length) {
                    name = String.valueOf(name) + indexesValues[i];
                    if (i < indexesValues.length - 1) {
                        name = String.valueOf(name) + ",";
                    }
                    ++i;
                }
                name = String.valueOf(name) + "}";
            }
            ParameterParser parser = new ParameterParser(this.value, this.inputData, this.currentParameters);
            int i = 0;
            while (i < index) {
                parser.getVars().put(String.valueOf(i + 1), new Integer(indexesValues[i]));
                ++i;
            }
            try {
                parser.parseValue();
                Number newParameter = parser.getFirstResult();
                if ((newParameter instanceof Double || newParameter instanceof Float) && newParameter.doubleValue() < 1.0) {
                    newParameter = Math.floor(newParameter.doubleValue() * 100000.0) / 100000.0;
                }
                System.out.println("Name: " + name + ", value = " + newParameter);
                this.parameters.put(name, newParameter);
                this.currentParameters.put(name, newParameter);
            }
            catch (Error e) {
                throw new ParameterParserException("\"" + this.value + "\" " + e.getMessage());
            }
            catch (ParseException e) {
                throw new ParameterParserException("\"" + this.value + "\": " + e.getMessage());
            }
        }
        ParameterParser parser = new ParameterParser(this.indexes.get(index), this.inputData, pLinguaParameters);
        int i = 0;
        while (i < index) {
            parser.getVars().put(String.valueOf(i + 1), new Integer(indexesValues[i]));
            ++i;
        }
        try {
            int n1;
            parser.parseIndex();
            int n2 = n1 = parser.getFirstResult().intValue();
            if (parser.getSecondResult() != null) {
                n2 = parser.getSecondResult().intValue();
            }
            if (n2 < n1) {
                int aux = n2;
                n2 = n1;
                n1 = aux;
            }
            int incremento = 1;
            if (parser.getThirdResult() != null) {
                incremento = parser.getThirdResult().intValue();
            }
            if (incremento > 0) {
                int i2 = n1;
                while (i2 <= n2) {
                    indexesValues[index] = i2;
                    this.generatePlinguaParametersRec(index + 1, indexesValues, pLinguaParameters);
                    i2 += incremento;
                }
            } else {
                int i3 = n2;
                while (i3 >= n1) {
                    indexesValues[index] = i3;
                    this.generatePlinguaParametersRec(index + 1, indexesValues, pLinguaParameters);
                    i3 += incremento;
                }
            }
        }
        catch (VoidRangeException n1) {
        }
        catch (Error e) {
            throw new ParameterParserException("\"" + this.indexes.get(index) + "\": " + e.getMessage());
        }
        catch (ParseException e) {
            throw new ParameterParserException("\"" + this.indexes.get(index) + "\": " + e.getMessage());
        }
    }

    public Map<String, Number> generatePlinguaParameters(IParameterParserInputData inputData, Map<String, Number> pLinguaParameters) throws ParameterParserException {
        this.parameters.clear();
        this.currentParameters.clear();
        this.currentParameters.putAll(pLinguaParameters);
        this.inputData = inputData;
        int[] indexesValues = null;
        if (!this.indexes.isEmpty()) {
            indexesValues = new int[this.indexes.size()];
        }
        System.out.println(pLinguaParameters);
        this.generatePlinguaParametersRec(0, indexesValues, pLinguaParameters);
        return this.parameters;
    }

    public String toString() {
        return "Parameter [name=" + this.name + ", indexes=" + this.indexes + ", value=" + this.value + "]";
    }
}

