/*
 * Decompiled with CFR 0.152.
 */
package ecoSim.gui.menu;

import ecoSim.actions.AbstractEcoSimAction;
import ecoSim.gui.AbstractEcoSimGUI;
import ecoSim.gui.AbstractEcoSimView;
import ecoSim.gui.menu.EcoSimMenuItem;
import ecoSim.gui.menu.EcoSimMenuSeparator;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;

public class EcoSimMenu
extends AbstractEcoSimView {
    private DefaultMutableTreeNode tree;
    public static final int TYPE_MENU_BAR = 0;
    public static final int TYPE_MENU_POPUP = 1;
    public static final int TYPE_MENU_SINGLE = 2;
    private int type = 0;

    public EcoSimMenu(String name, int type, AbstractEcoSimGUI gui) {
        super(name, false, gui);
        if (type != 0 && type != 1 && type != 2) {
            throw new IllegalArgumentException();
        }
        this.tree = new DefaultMutableTreeNode();
        this.type = type;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    private void addMenuItem(int[] position, DefaultMutableTreeNode tree, AbstractEcoSimView data) {
        int pos;
        int i = 0;
        while (i < position.length - 1) {
            int n = tree.getChildCount();
            if (position[i] >= n) {
                int j = n;
                while (j <= position[i]) {
                    tree.add(new DefaultMutableTreeNode());
                    ++j;
                }
            }
            tree = (DefaultMutableTreeNode)tree.getChildAt(position[i]);
            ++i;
        }
        int n = tree.getChildCount();
        if (n > (pos = position[position.length - 1])) {
            ((DefaultMutableTreeNode)tree.getChildAt(pos)).setUserObject(data);
        } else {
            if (n < pos) {
                int i2 = n;
                while (i2 < pos) {
                    tree.insert(new DefaultMutableTreeNode(), i2);
                    ++i2;
                }
            }
            tree.insert(new DefaultMutableTreeNode(data), pos);
        }
    }

    public void addMenuItem(String position, String name, AbstractEcoSimAction strategy, int group, boolean selected) {
        this.addMenuItem(this.strToArray(position), this.tree, new EcoSimMenuItem(name, strategy, this.getGUI(), group, selected));
    }

    private void addMenu(int[] position, String name, DefaultMutableTreeNode node) {
        if (node.isRoot()) {
            this.addMenuItem(position, this.tree, new EcoSimMenuItem(name, null, this.getGUI()));
        } else {
            this.addMenuItem(position, this.tree, (AbstractEcoSimView)node.getUserObject());
        }
        DefaultMutableTreeNode sibling = node.getNextSibling();
        if (sibling != null) {
            int n = position.length - 1;
            position[n] = position[n] + 1;
            this.addMenu(position, name, sibling);
            int n2 = position.length - 1;
            position[n2] = position[n2] - 1;
        }
        if (!node.isLeaf()) {
            int[] newPosition = new int[position.length + 1];
            int i = 0;
            while (i < position.length) {
                newPosition[i] = position[i];
                ++i;
            }
            newPosition[position.length] = 0;
            this.addMenu(newPosition, name, (DefaultMutableTreeNode)node.getFirstChild());
        }
    }

    public void addMenu(String name, EcoSimMenu menu) {
        if (menu == null) {
            throw new NullPointerException();
        }
        if (menu.tree.isLeaf()) {
            throw new IllegalArgumentException();
        }
        int[] position = new int[]{this.tree.getChildCount()};
        this.addMenu(position, name, menu.tree);
    }

    public void addMenu(EcoSimMenu menu) {
        if (menu == null) {
            throw new NullPointerException();
        }
        if (menu.tree.isLeaf()) {
            throw new IllegalArgumentException();
        }
        int[] position = new int[]{this.tree.getChildCount()};
        this.addMenu(position, null, (DefaultMutableTreeNode)menu.tree.getFirstChild());
    }

    public void addMenuItem(String position, String name) {
        this.addMenuItem(this.strToArray(position), this.tree, new EcoSimMenuItem(name, null, this.getGUI()));
    }

    public void addMenuItem(String position, String name, AbstractEcoSimAction strategy) {
        this.addMenuItem(this.strToArray(position), this.tree, new EcoSimMenuItem(name, strategy, this.getGUI()));
    }

    public void addMenuItem(String position, String name, AbstractEcoSimAction strategy, KeyStroke key) {
        this.addMenuItem(this.strToArray(position), this.tree, new EcoSimMenuItem(name, strategy, key, this.getGUI()));
    }

    public void addMenuSeparator(String position) {
        this.addMenuItem(this.strToArray(position), this.tree, new EcoSimMenuSeparator(this.getGUI()));
    }

    private int[] strToArray(String str) {
        String[] str1 = str.split(",");
        int[] r = new int[str1.length];
        int i = 0;
        while (i < str1.length) {
            r[i] = Integer.parseInt(str1[i].trim());
            ++i;
        }
        return r;
    }

    @Override
    public JComponent createSpecificView() {
        JComponent menu;
        ArrayList<DefaultMutableTreeNode> nodes = new ArrayList<DefaultMutableTreeNode>();
        ArrayList<JComponent> menus = new ArrayList<JComponent>();
        switch (this.type) {
            case 0: {
                menu = new JMenuBar();
                break;
            }
            case 1: {
                menu = new JPopupMenu();
                break;
            }
            default: {
                menu = new JMenu();
            }
        }
        menu.setName(this.getName());
        Enumeration<TreeNode> e = this.tree.breadthFirstEnumeration();
        while (e.hasMoreElements()) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)e.nextElement();
            Object data = node.getUserObject();
            if (data != null && data instanceof EcoSimMenuItem) {
                ((EcoSimMenuItem)data).setLeaf(node.isLeaf());
            }
            nodes.add(node);
        }
        int init_index = 1;
        int i = 0;
        while (i < nodes.size()) {
            int n = ((DefaultMutableTreeNode)nodes.get(i)).getChildCount();
            int j = init_index;
            while (j < init_index + n) {
                JComponent c = ((AbstractEcoSimView)((DefaultMutableTreeNode)nodes.get(j)).getUserObject()).getView();
                menus.add(c);
                if (((DefaultMutableTreeNode)nodes.get(i)).isRoot()) {
                    menu.add(c);
                } else {
                    ((JComponent)menus.get(i - 1)).add(c);
                }
                ++j;
            }
            init_index += n;
            ++i;
        }
        return menu;
    }
}

