/*
 * Decompiled with CFR 0.152.
 */
package ecoSim.gui;

import java.io.File;
import javax.swing.filechooser.FileFilter;

public class ConfigFileFilter
extends FileFilter {
    public static final int TYPE_XLS = 1;
    public static final int TYPE_ODS = 2;
    public static final int TYPE_BOTH = 3;
    private int type;
    private String[] ext;

    public ConfigFileFilter(int type) {
        this.type = type;
        this.ext = new String[2];
        switch (type) {
            case 1: {
                this.ext[0] = ".xls";
                this.ext[1] = ".xls";
                break;
            }
            case 3: {
                this.ext[0] = ".xls";
                this.ext[1] = ".ods";
                break;
            }
            case 2: {
                this.ext[0] = ".ods";
                this.ext[1] = ".ods";
            }
        }
    }

    @Override
    public boolean accept(File file) {
        if (file.isDirectory()) {
            return true;
        }
        if (file.getName().length() < 5) {
            return false;
        }
        int n = file.getName().lastIndexOf(".xls");
        int m = file.getName().lastIndexOf(".ods");
        return n == file.getName().length() - 4 || m == file.getName().length() - 4;
    }

    @Override
    public String getDescription() {
        String desc = "";
        if (this.type == 3) {
            desc = "Spreadsheet files (*.xls, *.ods)";
        }
        if (this.type == 1) {
            desc = "Spreadsheet files (*.xls)";
        }
        if (this.type == 2) {
            desc = "Spreadsheet files (*.ods)";
        }
        return desc;
    }

    public File completeExtension(File file) {
        if (this.type == 3) {
            return file;
        }
        String path = file.getAbsolutePath();
        String semipath = path.lastIndexOf(".") < 0 ? path : path.substring(0, path.lastIndexOf("."));
        if (this.type == 1) {
            path = String.valueOf(semipath) + ".xls";
        } else if (this.type == 2) {
            path = String.valueOf(semipath) + ".ods";
        }
        return new File(path);
    }
}

