/*
 * Decompiled with CFR 0.152.
 */
package ecoSim.factory;

import ecoSim.DAOFacade;
import ecoSim.data.AbstractEcoSimData;
import ecoSim.factory.CustomEcoSimData;
import ecoSim.factory.IParametersStrategy;
import ecoSim.parameterParser.Parameter;
import ecoSim.parameterParser.ParameterParserException;
import ecoSim.properties.UnavailablePropertyException;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public class CustomParametersStrategy
implements IParametersStrategy {
    @Override
    public Map<String, Number> getInitialParameters(AbstractEcoSimData data) {
        DAOFacade.restartEnvironment();
        if (!(data instanceof CustomEcoSimData)) {
            throw new IllegalArgumentException();
        }
        LinkedHashMap<String, Number> map = new LinkedHashMap<String, Number>();
        CustomEcoSimData cd = (CustomEcoSimData)data;
        Iterator<Parameter> it = cd.getParameters().iterator();
        try {
            while (it.hasNext()) {
                Parameter p = it.next();
                map.putAll(p.generatePlinguaParameters(cd, map));
            }
            cd.setParsedParameters(map);
        }
        catch (ParameterParserException e) {
            throw new IllegalStateException(e.getMessage());
        }
        if (cd.isSaveParameters()) {
            try {
                cd.getApplicationID();
                String parametersFilename = "";
                String dirPath = DAOFacade.getProperty("parameters-file-path");
                if (dirPath != null && !dirPath.equals("")) {
                    parametersFilename = dirPath;
                }
                parametersFilename = String.valueOf(parametersFilename) + (DAOFacade.getProperty("parameters-file-include-app").equalsIgnoreCase("yes") ? String.valueOf(cd.getApplicationName()) + "-" : "") + DAOFacade.getProperty("parameters-file");
                FileWriter fw = new FileWriter(parametersFilename);
                BufferedWriter bw = new BufferedWriter(fw);
                for (Map.Entry es : map.entrySet()) {
                    bw.write(String.valueOf((String)es.getKey()) + " = " + es.getValue() + ";\n");
                }
                bw.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (UnavailablePropertyException e) {
                e.printStackTrace();
            }
        }
        return map;
    }
}

