/*
 * Decompiled with CFR 0.152.
 */
package ecoSim.factory;

import ecoSim.DAOFacade;
import ecoSim.data.AbstractEcoSimData;
import ecoSim.data.DataBlockTableModel;
import ecoSim.entities.GeneralData;
import ecoSim.entities.TableData;
import ecoSim.factory.CustomDataBlock;
import ecoSim.factory.CustomOutputDataBlock;
import ecoSim.parameterParser.IParameterParserInputData;
import ecoSim.parameterParser.Parameter;
import ecoSim.parameterParser.ParameterParserException;
import java.io.File;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class CustomEcoSimData
extends AbstractEcoSimData
implements IParameterParserInputData {
    private static final long serialVersionUID = 1069831473365175568L;
    private GeneralData gd = null;
    private Map<String, Number> parsedParameters;

    public CustomEcoSimData(GeneralData gd) {
        super("CustomEcoSim", gd.getIdApp(), gd.getAppName(), gd.getVersionType(), "designer");
        this.gd = gd;
        this.parsedParameters = new LinkedHashMap<String, Number>();
        this.addDataBlocks();
    }

    public CustomEcoSimData() {
        super("CustomEcoSim", 1, "Custom Ecosystem Eco-Sim", "beta", "designer");
        this.parsedParameters = new LinkedHashMap<String, Number>();
        this.addDataBlocks();
    }

    private void addDataBlocks() {
        if (this.gd != null) {
            int appId = this.gd.getIdApp();
            List<TableData> inputTablesData = DAOFacade.getTablesData(appId, false);
            for (TableData tdata : inputTablesData) {
                this.addDataBlock(tdata.getTableConfig().getIdTabla(), new CustomDataBlock(tdata, (AbstractEcoSimData)this));
            }
            List<TableData> outputTablesData = DAOFacade.getTablesData(appId, true);
            for (TableData tdata : outputTablesData) {
                this.addOutputDataBlock(tdata.getTableConfig().getIdTabla(), new CustomOutputDataBlock(tdata, (AbstractEcoSimData)this));
            }
        }
    }

    @Override
    protected boolean loadEcoFile(File file) {
        boolean b = super.load(file);
        if (b) {
            try {
                Integer[] integerArray = this.dataBlockIndexes();
                int n = integerArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Integer Int = integerArray[n2];
                    int i = Int;
                    DataBlockTableModel dblock = this.getDataBlock(i);
                    dblock.update(true);
                    ++n2;
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            this.setState(2);
        }
        return b;
    }

    @Override
    public String getCellValue(int id, int row, int column) throws ParameterParserException {
        DataBlockTableModel data = this.getDataBlock(id);
        if (data == null) {
            throw new ParameterParserException("The id " + id + " is not a valid table id");
        }
        if (row < 1 || row > this.getRows(id)) {
            throw new ParameterParserException("Row " + row + " out of index");
        }
        if (column < 1 || column > this.getColumns(id)) {
            throw new ParameterParserException("Column " + column + " out of index");
        }
        Object obj = data.getValueAt(row - 1, column - 1);
        if (obj == null) {
            throw new ParameterParserException("Empty data at table " + id + ", row " + row + ", column " + column);
        }
        return data.getValueAt(row - 1, column - 1).toString();
    }

    @Override
    public int getColumns(int id) throws ParameterParserException {
        DataBlockTableModel data = this.getDataBlock(id);
        if (data == null) {
            throw new ParameterParserException("The id " + id + " is not a valid table id");
        }
        return data.getColumnCount();
    }

    @Override
    public int getRows(int id) throws ParameterParserException {
        DataBlockTableModel data = this.getDataBlock(id);
        if (data == null) {
            throw new ParameterParserException("The id " + id + " is not a valid table id");
        }
        return data.getRowCount();
    }

    public List<Parameter> getParameters() {
        List<Parameter> params = DAOFacade.getParameters(this.gd.getIdApp());
        return params;
    }

    @Override
    public void setPlinguaFile(File plinguaFile) {
        super.setPlinguaFile(plinguaFile);
        if (this.getSimulationAlgorithm() == null || this.getSimulationAlgorithm().equals("none")) {
            this.setDefaultSimulationAlgorithm(plinguaFile);
        }
    }

    @Override
    public boolean save(File ec2file, boolean validateAppId) {
        return super.save(ec2file, validateAppId);
    }

    @Override
    public boolean loadCnfFile() {
        boolean userModeAux;
        GeneralData data = DAOFacade.getGeneralData();
        boolean bl = userModeAux = !data.getMode().equals("Designer");
        if (userModeAux) {
            this.setUserMode(true);
        } else {
            this.setUserMode(false);
        }
        String modelPath = data.getModelPath();
        if (modelPath != null && !data.getModelPath().equals("")) {
            this.setPlinguaFile(new File(modelPath));
        }
        this.load(new File(data.getDataPath()));
        this.setSimulatedCycles(data.getSimulatedYears());
        this.setSimulationsByCycle(data.getSimulationsByYear());
        this.setStepsByCycle(data.getStepsByYear());
        this.setSimulationAlgorithm(data.getCurrentSimulator());
        return true;
    }

    @Override
    public boolean saveCnfFile() {
        GeneralData data = DAOFacade.getGeneralData();
        if (this.isUserMode()) {
            data.setMode("User");
        } else {
            data.setMode("Designer");
            if (this.getPlinguaFile() != null && !this.getPlinguaFile().getPath().equals("")) {
                data.setModelPath(this.getPlinguaFile().getAbsolutePath());
            }
        }
        data.setSimulatedYears(this.getSimulatedCycles());
        data.setSimulationsByYear(this.getSimulationsByCycle());
        data.setStepsByYear(this.getStepsByCycle());
        data.setCurrentSimulator(this.getSimulationAlgorithm());
        if (this.getDataFile() != null) {
            data.setDataPath(this.getDataFile().getAbsolutePath());
        }
        DAOFacade.setGeneralData(data);
        return true;
    }

    public Map<String, Number> getParsedParameters() {
        return this.parsedParameters;
    }

    public void setParsedParameters(Map<String, Number> parsedParameters) {
        this.parsedParameters = parsedParameters;
        DAOFacade.refreshParameters(this.gd.getIdApp(), parsedParameters);
    }

    public String getDataPath() {
        GeneralData data = DAOFacade.getGeneralData();
        return data.getDataPath();
    }

    @Override
    public void setSimulationAlgorithm(String simulationAlgorithm) {
        super.setSimulationAlgorithm(simulationAlgorithm);
        GeneralData data = DAOFacade.getGeneralData();
        data.setCurrentSimulator(simulationAlgorithm);
        DAOFacade.setGeneralData(data);
    }

    private void setDefaultSimulationAlgorithm(File f) {
        if (f != null && f.exists() && !f.isDirectory()) {
            Iterator<String> it = DAOFacade.getAvailableSimulatorsForModel(f);
            String candidateAlgorithm = "none";
            if (it != null) {
                while (it.hasNext()) {
                    candidateAlgorithm = it.next();
                }
                this.setSimulationAlgorithm(candidateAlgorithm);
            }
        }
    }

    public boolean isSaveParameters() {
        return this.gd.isSaveParameters();
    }
}

