/*
 * Decompiled with CFR 0.152.
 */
package ecoSim.actions;

import ecoSim.actions.AbstractEcoSimAction;
import ecoSim.gui.AbstractEcoSimGUI;
import java.util.HashMap;
import java.util.Map;

public class EcoSimChangeAlgorithmAction
extends AbstractEcoSimAction {
    private static Map<String, EcoSimChangeAlgorithmAction> singletons;
    private String algorithm;

    private EcoSimChangeAlgorithmAction(String algorithm) {
        this.algorithm = algorithm;
    }

    public static EcoSimChangeAlgorithmAction getInstance(String algorithm) {
        EcoSimChangeAlgorithmAction singleton;
        if (singletons == null) {
            singletons = new HashMap<String, EcoSimChangeAlgorithmAction>();
        }
        if ((singleton = singletons.get(algorithm)) == null) {
            singleton = new EcoSimChangeAlgorithmAction(algorithm);
            singletons.put(algorithm, singleton);
        }
        return singleton;
    }

    @Override
    protected void doSecureAction(AbstractEcoSimGUI gui) {
        gui.getData().setSimulationAlgorithm(this.algorithm);
    }

    @Override
    public boolean isEnabledAction(AbstractEcoSimGUI gui) {
        return gui.getData().getState() != 4;
    }
}

