/*
 * Decompiled with CFR 0.152.
 */
package ecoSim;

import ecoSim.ClasspathManager;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ReflectionManager {
    private static ReflectionManager rm;
    private static Set<String> pluginFiles;

    public static Set<String> getPluginFiles() {
        return pluginFiles;
    }

    private ReflectionManager() {
        pluginFiles = new HashSet<String>();
    }

    public static ReflectionManager getInstance() {
        if (rm == null) {
            rm = new ReflectionManager();
            try {
                ClasspathManager mc = new ClasspathManager();
                File folder = new File("plugins/");
                ReflectionManager.addFiles(mc, folder);
            }
            catch (NoSuchMethodException e1) {
                e1.printStackTrace();
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
        }
        return rm;
    }

    private static void addFiles(ClasspathManager mc, File folder) throws MalformedURLException {
        File[] files;
        if (folder != null && (files = folder.listFiles()) != null && files.length > 0) {
            File[] fileArray = folder.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                if (!f.isDirectory() && f.getName().endsWith(".jar")) {
                    mc.addFile(f);
                    pluginFiles.add(f.getName());
                } else {
                    ReflectionManager.addFiles(mc, f);
                }
                ++n2;
            }
        }
    }

    public Object invoke(String className, String methodName, List<Object> params) throws Exception {
        Object res = null;
        ArrayList<String> lParametros = new ArrayList<String>();
        for (Object object : params) {
            lParametros.add(object.getClass().getName());
        }
        try {
            Class clase = this.getClass(className);
            Object instance = clase.newInstance();
            Class[] parametros = new Class[lParametros.size()];
            int j = 0;
            for (String cName : lParametros) {
                parametros[j++] = this.getClass(cName);
            }
            Method[] methodArray = clase.getMethods();
            int n = methodArray.length;
            int n2 = 0;
            while (n2 < n) {
                Method method = methodArray[n2];
                if (method.getName().equals(methodName)) {
                    Class<?>[] parameterTypes = method.getParameterTypes();
                    boolean matches = true;
                    int i = 0;
                    while (i < parameterTypes.length) {
                        if (!parameterTypes[i].isAssignableFrom(parametros[i])) {
                            matches = false;
                            break;
                        }
                        ++i;
                    }
                    if (matches) {
                        try {
                            method.setAccessible(true);
                            res = method.invoke(instance, params.toArray(new Object[params.size()]));
                        }
                        catch (IllegalArgumentException e) {
                            e.printStackTrace();
                        }
                        catch (IllegalAccessException e) {
                            e.printStackTrace();
                        }
                        catch (InvocationTargetException e) {
                            e.printStackTrace();
                        }
                        break;
                    }
                }
                ++n2;
            }
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        return res;
    }

    public Class getClass(String clazz) throws Exception {
        Class<?> result = null;
        try {
            result = Class.forName(clazz);
        }
        catch (ClassNotFoundException e) {
            System.err.println("Class " + clazz + " not found");
            e.printStackTrace();
            throw new Exception("Class " + clazz + " not found", e);
        }
        catch (NullPointerException e) {
            System.err.println("The name of the class is set to null ");
            e.printStackTrace();
            throw new Exception("The name of the class is set to null ", e);
        }
        return result;
    }

    public int receivesParameter(String className, String methodName, Class c) throws Exception {
        int parameterNumber = -1;
        boolean hasGoodParamType = false;
        try {
            Class clase = this.getClass(className);
            Method[] methods = clase.getMethods();
            int i = 0;
            while (i < methods.length && !hasGoodParamType) {
                if (methods[i].getName().equals(methodName)) {
                    Class<?>[] parameterTypes = methods[i].getParameterTypes();
                    int j = 0;
                    while (j < parameterTypes.length && !hasGoodParamType) {
                        if (parameterTypes[j].getName().equals(c.getName())) {
                            parameterNumber = j;
                            hasGoodParamType = true;
                            continue;
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        return parameterNumber;
    }

    public int receivesParameter(String className, String methodName, Object o) throws Exception {
        return this.receivesParameter(className, methodName, o.getClass());
    }
}

