/*
 * Decompiled with CFR 0.152.
 */
package others;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class LayeredPaneDemo
extends JPanel
implements ActionListener,
MouseMotionListener {
    private String[] layerStrings = new String[]{"Yellow (0)", "Magenta (1)", "Cyan (2)", "Red (3)", "Green (4)"};
    private Color[] layerColors = new Color[]{Color.yellow, Color.magenta, Color.cyan, Color.red, Color.green};
    private JLayeredPane layeredPane;
    private JLabel dukeLabel;
    private JCheckBox onTop;
    private JComboBox layerList;
    private static String ON_TOP_COMMAND = "ontop";
    private static String LAYER_COMMAND = "layer";
    private static final int XFUDGE = 40;
    private static final int YFUDGE = 57;

    public LayeredPaneDemo() {
        this.setLayout(new BoxLayout(this, 3));
        ImageIcon icon = LayeredPaneDemo.createImageIcon("images/dukeWaveRed.gif");
        this.layeredPane = new JLayeredPane();
        this.layeredPane.setPreferredSize(new Dimension(300, 310));
        this.layeredPane.setBorder(BorderFactory.createTitledBorder("Move the Mouse to Move Duke"));
        this.layeredPane.addMouseMotionListener(this);
        Point origin = new Point(10, 20);
        int offset = 35;
        int i = 0;
        while (i < this.layerStrings.length) {
            JLabel label = this.createColoredLabel(this.layerStrings[i], this.layerColors[i], origin);
            this.layeredPane.add((Component)label, new Integer(i));
            origin.x += offset;
            origin.y += offset;
            ++i;
        }
        this.dukeLabel = new JLabel(icon);
        if (icon != null) {
            this.dukeLabel.setBounds(15, 225, icon.getIconWidth(), icon.getIconHeight());
        } else {
            System.err.println("Duke icon not found; using black square instead.");
            this.dukeLabel.setBounds(15, 225, 30, 30);
            this.dukeLabel.setOpaque(true);
            this.dukeLabel.setBackground(Color.BLACK);
        }
        this.layeredPane.add(this.dukeLabel, new Integer(2), 0);
        this.add(Box.createRigidArea(new Dimension(0, 10)));
        this.add(this.createControlPanel());
        this.add(Box.createRigidArea(new Dimension(0, 10)));
        this.add(this.layeredPane);
    }

    protected static ImageIcon createImageIcon(String path) {
        URL imgURL = LayeredPaneDemo.class.getResource(path);
        if (imgURL != null) {
            return new ImageIcon(imgURL);
        }
        System.err.println("Couldn't find file: " + path);
        return null;
    }

    private JLabel createColoredLabel(String text, Color color, Point origin) {
        JLabel label = new JLabel(text);
        label.setVerticalAlignment(1);
        label.setHorizontalAlignment(0);
        label.setOpaque(true);
        label.setBackground(color);
        label.setForeground(Color.black);
        label.setBorder(BorderFactory.createLineBorder(Color.black));
        label.setBounds(origin.x, origin.y, 140, 140);
        return label;
    }

    private JPanel createControlPanel() {
        this.onTop = new JCheckBox("Top Position in Layer");
        this.onTop.setSelected(true);
        this.onTop.setActionCommand(ON_TOP_COMMAND);
        this.onTop.addActionListener(this);
        this.layerList = new JComboBox<String>(this.layerStrings);
        this.layerList.setSelectedIndex(2);
        this.layerList.setActionCommand(LAYER_COMMAND);
        this.layerList.addActionListener(this);
        JPanel controls = new JPanel();
        controls.add(this.layerList);
        controls.add(this.onTop);
        controls.setBorder(BorderFactory.createTitledBorder("Choose Duke's Layer and Position"));
        return controls;
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.dukeLabel.setLocation(e.getX() - 40, e.getY() - 57);
    }

    @Override
    public void mouseDragged(MouseEvent e) {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if (ON_TOP_COMMAND.equals(cmd)) {
            if (this.onTop.isSelected()) {
                this.layeredPane.moveToFront(this.dukeLabel);
            } else {
                this.layeredPane.moveToBack(this.dukeLabel);
            }
        } else if (LAYER_COMMAND.equals(cmd)) {
            int position = this.onTop.isSelected() ? 0 : 1;
            this.layeredPane.setLayer(this.dukeLabel, this.layerList.getSelectedIndex(), position);
        }
    }

    private static void createAndShowGUI() {
        JFrame frame = new JFrame("LayeredPaneDemo");
        frame.setDefaultCloseOperation(3);
        LayeredPaneDemo newContentPane = new LayeredPaneDemo();
        newContentPane.setOpaque(true);
        frame.setContentPane(newContentPane);
        frame.pack();
        frame.setVisible(true);
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                LayeredPaneDemo.createAndShowGUI();
            }
        });
    }
}

