/*
 * Decompiled with CFR 0.152.
 */
package demo;

import java.awt.Color;
import java.awt.Dimension;
import javax.swing.JPanel;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.StatisticalBarRenderer;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.statistics.DefaultStatisticalCategoryDataset;
import org.jfree.ui.ApplicationFrame;
import org.jfree.ui.RefineryUtilities;

public class StatisticalBarChartDemo1
extends ApplicationFrame {
    public StatisticalBarChartDemo1(String title) {
        super(title);
        CategoryDataset dataset = StatisticalBarChartDemo1.createDataset();
        JFreeChart chart = StatisticalBarChartDemo1.createChart(dataset);
        ChartPanel chartPanel = new ChartPanel(chart);
        chartPanel.setPreferredSize(new Dimension(500, 270));
        this.setContentPane(chartPanel);
    }

    private static CategoryDataset createDataset() {
        DefaultStatisticalCategoryDataset dataset = new DefaultStatisticalCategoryDataset();
        dataset.add(10.0, 2.4, (Comparable)((Object)"Row 1"), (Comparable)((Object)"Column 1"));
        dataset.add(15.0, 4.4, (Comparable)((Object)"Row 1"), (Comparable)((Object)"Column 2"));
        dataset.add(13.0, 2.1, (Comparable)((Object)"Row 1"), (Comparable)((Object)"Column 3"));
        dataset.add(7.0, 1.3, (Comparable)((Object)"Row 1"), (Comparable)((Object)"Column 4"));
        dataset.add(22.0, 2.4, (Comparable)((Object)"Row 2"), (Comparable)((Object)"Column 1"));
        dataset.add(18.0, 4.4, (Comparable)((Object)"Row 2"), (Comparable)((Object)"Column 2"));
        dataset.add(28.0, 2.1, (Comparable)((Object)"Row 2"), (Comparable)((Object)"Column 3"));
        dataset.add(17.0, 1.3, (Comparable)((Object)"Row 2"), (Comparable)((Object)"Column 4"));
        return dataset;
    }

    private static JFreeChart createChart(CategoryDataset dataset) {
        JFreeChart chart = ChartFactory.createLineChart("Statistical Bar Chart Demo 1", "Type", "Value", dataset, PlotOrientation.VERTICAL, true, true, false);
        chart.setBackgroundPaint(Color.white);
        CategoryPlot plot = (CategoryPlot)chart.getPlot();
        plot.setBackgroundPaint(Color.lightGray);
        plot.setRangeGridlinePaint(Color.white);
        NumberAxis rangeAxis = (NumberAxis)plot.getRangeAxis();
        rangeAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        rangeAxis.setAutoRangeIncludesZero(true);
        StatisticalBarRenderer renderer = new StatisticalBarRenderer();
        renderer.setErrorIndicatorPaint(Color.black);
        plot.setRenderer(renderer);
        return chart;
    }

    public static JPanel createDemoPanel() {
        JFreeChart chart = StatisticalBarChartDemo1.createChart(StatisticalBarChartDemo1.createDataset());
        return new ChartPanel(chart);
    }

    public static void main(String[] args) {
        StatisticalBarChartDemo1 demo = new StatisticalBarChartDemo1("Statistical Bar Chart Demo");
        demo.pack();
        RefineryUtilities.centerFrameOnScreen(demo);
        demo.setVisible(true);
    }
}

