/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Dimension;
import javax.swing.JPanel;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.StackedBarRenderer;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.ui.ApplicationFrame;
import org.jfree.ui.RefineryUtilities;

public class StackedBarChartDemo6
extends ApplicationFrame {
    private static final long serialVersionUID = 1L;

    public StackedBarChartDemo6(String s) {
        super(s);
        JPanel jpanel = StackedBarChartDemo6.createDemoPanel();
        jpanel.setPreferredSize(new Dimension(500, 270));
        this.setContentPane(jpanel);
    }

    private static CategoryDataset createDataset() {
        DefaultCategoryDataset defaultcategorydataset = new DefaultCategoryDataset();
        long l = 86400000L;
        defaultcategorydataset.addValue(3L * l, (Comparable)((Object)"Series 1"), (Comparable)((Object)"Category 1"));
        defaultcategorydataset.addValue(1L * l, (Comparable)((Object)"Series 2"), (Comparable)((Object)"Category 1"));
        defaultcategorydataset.addValue(2L * l, (Comparable)((Object)"Series 3"), (Comparable)((Object)"Category 1"));
        defaultcategorydataset.addValue(4L * l, (Comparable)((Object)"Series 1"), (Comparable)((Object)"Category 2"));
        defaultcategorydataset.addValue(5L * l, (Comparable)((Object)"Series 2"), (Comparable)((Object)"Category 2"));
        defaultcategorydataset.addValue(1L * l, (Comparable)((Object)"Series 3"), (Comparable)((Object)"Category 2"));
        return defaultcategorydataset;
    }

    private static JFreeChart createChart(CategoryDataset categorydataset) {
        JFreeChart jfreechart = ChartFactory.createStackedBarChart("Stacked Bar Chart Demo 6", "Category", "Value", categorydataset, PlotOrientation.VERTICAL, true, true, false);
        jfreechart.setBackgroundPaint(Color.white);
        CategoryPlot categoryplot = (CategoryPlot)jfreechart.getPlot();
        categoryplot.setBackgroundPaint(Color.lightGray);
        categoryplot.setRangeGridlinePaint(Color.white);
        StackedBarRenderer stackedbarrenderer = (StackedBarRenderer)categoryplot.getRenderer();
        stackedbarrenderer.setDrawBarOutline(false);
        long l = System.currentTimeMillis();
        stackedbarrenderer.setBase(l);
        DateAxis dateaxis = new DateAxis("Date");
        categoryplot.setRangeAxis(dateaxis);
        return jfreechart;
    }

    public static JPanel createDemoPanel() {
        JFreeChart jfreechart = StackedBarChartDemo6.createChart(StackedBarChartDemo6.createDataset());
        return new ChartPanel(jfreechart);
    }

    public static void main(String[] args) {
        StackedBarChartDemo6 stackedbarchartdemo6 = new StackedBarChartDemo6("Stacked Bar Chart Demo 6");
        stackedbarchartdemo6.pack();
        RefineryUtilities.centerFrameOnScreen(stackedbarchartdemo6);
        stackedbarchartdemo6.setVisible(true);
    }
}

