/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Paint;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartFrame;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.LegendItem;
import org.jfree.chart.LegendItemCollection;
import org.jfree.chart.axis.SubCategoryAxis;
import org.jfree.chart.labels.StandardCategoryToolTipGenerator;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.GroupedStackedBarRenderer;
import org.jfree.data.KeyToGroupMap;
import org.jfree.data.category.DefaultCategoryDataset;

public class PruebaStackedBarChart {
    private String name;
    private String[][] resultTable;
    private String group;
    private String subgroup;
    private String part;
    private String dataName;

    public PruebaStackedBarChart() {
    }

    public PruebaStackedBarChart(String name, String[][] resultTable, String group, String subgroup, String part, String dataName) {
        this.name = name;
        this.resultTable = resultTable;
        this.group = group;
        this.subgroup = subgroup;
        this.part = part;
        this.dataName = dataName;
    }

    /*
     * WARNING - void declaration
     */
    public void showGraph() {
        if (this.resultTable != null && this.resultTable[0] != null && this.resultTable[0].length == 4) {
            Object item;
            void var15_19;
            Tupla t;
            Object groupValue;
            Object partData;
            void var15_16;
            DefaultCategoryDataset dataset = new DefaultCategoryDataset();
            ArrayList<String> subgroups = new ArrayList<String>();
            ArrayList<String> parts = new ArrayList<String>();
            List<Color> colors = this.generateColors();
            HashMap<String, PaintElement> paintsMap = new HashMap<String, PaintElement>();
            HashMap<String, PaintElement> paintsMap2 = new HashMap<String, PaintElement>();
            String[] paintsMapKeys = new String[this.resultTable.length];
            Paint[] paints = new Paint[this.resultTable.length];
            int assignedColors = 0;
            int orderedColors = 0;
            LinkedHashMap<String, Tupla> lhm = new LinkedHashMap<String, Tupla>();
            TreeSet<Object> grupos = new TreeSet<Object>();
            TreeSet<String> subgrupos = new TreeSet<String>();
            TreeSet<Object> partes = new TreeSet<Object>();
            boolean bl = false;
            while (var15_16 < this.resultTable.length) {
                double value = Double.parseDouble(this.resultTable[var15_16][3]);
                partData = this.resultTable[var15_16][2];
                String string = this.resultTable[var15_16][1];
                groupValue = String.valueOf(this.group) + " " + this.resultTable[var15_16][0];
                grupos.add(groupValue);
                subgrupos.add(string);
                partes.add(partData);
                ++var15_16;
            }
            for (String string : grupos) {
                for (String string2 : subgrupos) {
                    for (String string3 : partes) {
                        t = new Tupla(string, string2, string3, 0.0);
                        lhm.put(t.getClave(), t);
                    }
                }
            }
            boolean bl2 = false;
            while (var15_19 < this.resultTable.length) {
                double value = Double.parseDouble(this.resultTable[var15_19][3]);
                partData = this.resultTable[var15_19][2];
                String string = this.resultTable[var15_19][1];
                groupValue = String.valueOf(this.group) + " " + this.resultTable[var15_19][0];
                t = new Tupla((String)groupValue, string, (String)partData, value);
                String element = String.valueOf(string) + " (" + t.getPartValue(this.part) + ")";
                lhm.put(t.getClave(), t);
                ++var15_19;
            }
            Collection collection = lhm.values();
            for (Tupla t2 : collection) {
                dataset.addValue(t2.valor, (Comparable)((Object)t2.getElemento(this.part)), (Comparable)((Object)t2.grupo));
                if (subgroups.indexOf(t2.subgrupo) == -1) {
                    subgroups.add(t2.subgrupo);
                }
                if (parts.indexOf(t2.getPartValue(this.part)) == -1) {
                    parts.add(t2.getPartValue(this.part));
                    GradientPaint p = new GradientPaint(0.0f, 0.0f, colors.get(assignedColors % colors.size()), 0.0f, 0.0f, colors.get(assignedColors % colors.size()));
                    PaintElement paintElement = new PaintElement();
                    paintElement.p = p;
                    paintElement.partValue = t2.getPartValue(this.part);
                    paintElement.partData = t2.partData;
                    paintsMap.put(t2.partData, paintElement);
                    paints[assignedColors] = ((PaintElement)paintsMap.get((Object)t2.partData)).p;
                    ++assignedColors;
                }
                if (paintsMap2.get(t2.getElemento(this.part)) != null) continue;
                paintsMap2.put(t2.getElemento(this.part), (PaintElement)paintsMap.get(t2.partData));
                paintsMapKeys[orderedColors] = t2.getElemento(this.part);
                ++orderedColors;
            }
            String domain = String.valueOf(this.subgroup) + " / " + this.group + " - " + this.part;
            String string = this.dataName;
            JFreeChart chart = ChartFactory.createStackedBarChart(this.name.concat(" Stacked Bar Chart"), domain, string, dataset, PlotOrientation.VERTICAL, true, true, false);
            GroupedStackedBarRenderer groupedStackedBarRenderer = new GroupedStackedBarRenderer();
            String prefix = "G";
            String defaultGroup = String.valueOf(prefix) + 1;
            KeyToGroupMap map = new KeyToGroupMap((Comparable)((Object)defaultGroup));
            int groupIndex = 1;
            for (String subgroupValue2 : subgroups) {
                for (String partValue : parts) {
                    String elementName = String.valueOf(subgroupValue2) + " (" + partValue + ")";
                    String groupName = String.valueOf(prefix) + groupIndex;
                    map.mapKeyToGroup((Comparable)((Object)elementName), (Comparable)((Object)groupName));
                    System.out.println("Mapeando " + elementName + " con " + groupName);
                }
                ++groupIndex;
            }
            groupedStackedBarRenderer.setSeriesToGroupMap(map);
            groupedStackedBarRenderer.setBaseToolTipGenerator(new StandardCategoryToolTipGenerator());
            LegendItemCollection items = new LegendItemCollection();
            Set keys = paintsMap.keySet();
            ArrayList keysList = new ArrayList(keys);
            ArrayList<Integer> keysListI = new ArrayList<Integer>();
            boolean numericOrder = true;
            Iterator it = keysList.iterator();
            while (it.hasNext() && numericOrder) {
                String s = (String)it.next();
                if (s.matches("[0-9]*(.[0-9])?")) {
                    keysListI.add(new Integer(Integer.parseInt(s)));
                    continue;
                }
                numericOrder = false;
            }
            if (numericOrder) {
                Collections.sort(keysListI);
                for (Integer i2 : keysListI) {
                    item = new LegendItem(((PaintElement)paintsMap.get((Object)i2.toString())).partData, ((PaintElement)paintsMap.get((Object)i2.toString())).p);
                    items.add((LegendItem)item);
                }
            } else {
                for (String s : keysList) {
                    item = new LegendItem(((PaintElement)paintsMap.get((Object)s)).partData, ((PaintElement)paintsMap.get((Object)s)).p);
                    items.add((LegendItem)item);
                }
            }
            int i3 = 0;
            while (i3 < orderedColors) {
                groupedStackedBarRenderer.setSeriesPaint(i3, ((PaintElement)paintsMap2.get((Object)paintsMapKeys[i3])).p);
                ++i3;
            }
            SubCategoryAxis domainAxis = new SubCategoryAxis(domain);
            domainAxis.setCategoryMargin(0.05);
            for (String subgroupValue3 : subgroups) {
                domainAxis.addSubCategory((Comparable)((Object)subgroupValue3));
            }
            CategoryPlot plot = (CategoryPlot)chart.getPlot();
            plot.setDomainAxis(domainAxis);
            plot.setRenderer(groupedStackedBarRenderer);
            plot.setFixedLegendItems(items);
            ChartFrame frame = new ChartFrame(this.name, chart);
            frame.pack();
            frame.setVisible(true);
        }
    }

    private List<Color> generateColors() {
        ArrayList<Color> colors = new ArrayList<Color>();
        colors.add(new Color(255, 128, 192));
        colors.add(new Color(255, 255, 128));
        colors.add(new Color(128, 255, 128));
        colors.add(new Color(0, 128, 255));
        colors.add(new Color(255, 0, 0));
        colors.add(new Color(128, 128, 192));
        colors.add(new Color(128, 128, 64));
        colors.add(new Color(255, 128, 64));
        colors.add(new Color(0, 128, 128));
        colors.add(new Color(0, 64, 128));
        colors.add(new Color(0, 128, 0));
        colors.add(new Color(0, 0, 255));
        colors.add(new Color(128, 0, 128));
        colors.add(new Color(128, 128, 0));
        colors.add(new Color(64, 0, 64));
        colors.add(new Color(0, 255, 255));
        colors.add(new Color(128, 0, 255));
        colors.add(new Color(204, 238, 136));
        colors.add(new Color(34, 34, 68));
        colors.add(new Color(68, 102, 68));
        colors.add(new Color(102, 136, 68));
        colors.add(new Color(136, 170, 68));
        colors.add(new Color(170, 204, 68));
        colors.add(new Color(204, 238, 68));
        colors.add(new Color(34, 255, 68));
        colors.add(new Color(255, 102, 68));
        colors.add(new Color(255, 255, 68));
        colors.add(new Color(136, 255, 68));
        colors.add(new Color(170, 170, 68));
        colors.add(new Color(204, 0, 68));
        return colors;
    }

    public static void main(String[] args) {
        String[][] resultTable = PruebaStackedBarChart.inicializaTabla();
        String group = "Year";
        String subgroup = "Spec";
        String part = "Age";
        String dataName = "Population Media";
        PruebaStackedBarChart prueba = new PruebaStackedBarChart("Lote", resultTable, group, subgroup, part, dataName);
        prueba.showGraph();
    }

    private static String[][] inicializaTabla() {
        String[][] resultTable = new String[][]{{"1", "1", "1", "1078.0"}, {"1", "1", "2", "2525.0"}, {"1", "1", "3", "1683.0"}, {"1", "1", "4", "900.0"}, {"1", "1", "5", "676.0"}, {"1", "1", "6", "105.0"}, {"1", "1", "7", "370.0"}, {"1", "1", "8", "277.0"}, {"1", "1", "9", "146.0"}, {"1", "1", "10", "28.0"}, {"1", "1", "11", "3.0"}, {"1", "1", "12", "12.0"}, {"1", "1", "13", "13.0"}, {"1", "1", "14", "7.0"}, {"1", "1", "15", "6.0"}, {"1", "1", "16", "5.0"}, {"1", "1", "17", "4.0"}, {"1", "1", "18", "4.0"}, {"1", "1", "19", "3.0"}, {"1", "1", "20", "2.0"}, {"1", "1", "21", "2.0"}, {"1", "1", "22", "1.0"}, {"1", "1", "23", "1.0"}, {"1", "1", "24", "1.0"}, {"1", "1", "25", "1.0"}, {"1", "1", "26", "1.0"}, {"1", "2", "2", "192.0"}, {"2", "1", "1", "5310.0"}, {"2", "1", "2", "858.0"}, {"2", "1", "3", "2010.0"}, {"2", "1", "4", "1341.0"}, {"2", "1", "5", "739.0"}, {"2", "1", "6", "555.0"}, {"2", "1", "7", "85.0"}, {"2", "1", "8", "298.0"}, {"2", "1", "9", "227.0"}, {"2", "1", "10", "130.0"}, {"2", "1", "11", "25.0"}, {"2", "1", "12", "3.0"}, {"2", "1", "13", "11.0"}, {"2", "1", "14", "12.0"}, {"2", "1", "15", "6.0"}, {"2", "1", "16", "6.0"}, {"2", "1", "17", "4.0"}, {"2", "1", "18", "4.0"}, {"2", "1", "19", "3.0"}, {"2", "1", "20", "3.0"}, {"2", "1", "21", "1.0"}, {"2", "1", "22", "1.0"}, {"2", "1", "23", "1.0"}, {"2", "1", "24", "1.0"}, {"2", "1", "25", "1.0"}, {"2", "1", "26", "1.0"}, {"2", "2", "1", "127.0"}, {"2", "2", "4", "380.0"}, {"2", "2", "5", "183.0"}};
        return resultTable;
    }
}

