/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.dyno.visual.swing.layouts.Constraints;
import org.dyno.visual.swing.layouts.GroupLayout;
import org.dyno.visual.swing.layouts.Leading;

public class HaskellInterpreter
extends JFrame
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private JTextArea jTextArea0;
    private JScrollPane jScrollPane0;
    private JTextField jTextField0;
    private JButton jButton0;
    private JTextArea jTextArea1;
    private JScrollPane jScrollPane1;
    private JLabel jLabel0;
    private JLabel jLabel1;
    private static final String PREFERRED_LOOK_AND_FEEL = "com.sun.java.swing.plaf.nimbus.NimbusLookAndFeel";

    public HaskellInterpreter() {
        this.initComponents();
    }

    private void initComponents() {
        this.setTitle("Haskell Interpreter from Java");
        this.setIconImage(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/Haskell-Logo-Variation.png")));
        this.setResizable(false);
        this.setLayout(new GroupLayout());
        this.add((Component)this.getJTextField0(), new Constraints(new Leading(173, 126, 12, 12), new Leading(346, 10, 10)));
        this.add((Component)this.getJButton0(), new Constraints(new Leading(211, 12, 12), new Leading(295, 10, 10)));
        this.add((Component)this.getJScrollPane0(), new Constraints(new Leading(38, 397, 10, 10), new Leading(59, 215, 10, 10)));
        this.add((Component)this.getJScrollPane1(), new Constraints(new Leading(485, 333, 10, 10), new Leading(58, 216, 12, 12)));
        this.add((Component)this.getJLabel0(), new Constraints(new Leading(42, 10, 10), new Leading(25, 12, 12)));
        this.add((Component)this.getJLabel1(), new Constraints(new Leading(485, 12, 12), new Leading(24, 12, 12)));
        this.setSize(864, 407);
    }

    private JLabel getJLabel1() {
        if (this.jLabel1 == null) {
            this.jLabel1 = new JLabel();
            this.jLabel1.setText("Output of the Haskell program");
        }
        return this.jLabel1;
    }

    private JLabel getJLabel0() {
        if (this.jLabel0 == null) {
            this.jLabel0 = new JLabel();
            this.jLabel0.setFont(new Font("Arial Narrow", 1, 14));
            this.jLabel0.setText("-- Put your Haskell code here!");
        }
        return this.jLabel0;
    }

    private JScrollPane getJScrollPane1() {
        if (this.jScrollPane1 == null) {
            this.jScrollPane1 = new JScrollPane();
            this.jScrollPane1.setViewportView(this.getJTextArea1());
        }
        return this.jScrollPane1;
    }

    private JTextArea getJTextArea1() {
        if (this.jTextArea1 == null) {
            this.jTextArea1 = new JTextArea();
            this.jTextArea1.setFont(new Font("Courier New", 1, 14));
            this.jTextArea1.setAutoscrolls(true);
        }
        return this.jTextArea1;
    }

    private JButton getJButton0() {
        if (this.jButton0 == null) {
            this.jButton0 = new JButton("Run");
            this.jButton0.addActionListener(this);
        }
        return this.jButton0;
    }

    private JTextField getJTextField0() {
        if (this.jTextField0 == null) {
            this.jTextField0 = new JTextField();
            this.jTextField0.setFont(new Font("Courier New", 1, 16));
            this.jTextField0.setAutoscrolls(true);
        }
        return this.jTextField0;
    }

    private JScrollPane getJScrollPane0() {
        if (this.jScrollPane0 == null) {
            this.jScrollPane0 = new JScrollPane();
            this.jScrollPane0.setViewportView(this.getJTextArea0());
        }
        return this.jScrollPane0;
    }

    private JTextArea getJTextArea0() {
        if (this.jTextArea0 == null) {
            this.jTextArea0 = new JTextArea();
            this.jTextArea0.setFont(new Font("Courier New", 1, 14));
            this.jTextArea0.setToolTipText("-- Put your Haskell code here!");
            this.jTextArea0.setAutoscrolls(true);
        }
        return this.jTextArea0;
    }

    private static void installLnF() {
        try {
            String lnfClassname = PREFERRED_LOOK_AND_FEEL;
            if (lnfClassname == null) {
                lnfClassname = UIManager.getCrossPlatformLookAndFeelClassName();
            }
            UIManager.setLookAndFeel(lnfClassname);
        }
        catch (Exception e) {
            System.err.println("Cannot install com.sun.java.swing.plaf.nimbus.NimbusLookAndFeel on this platform:" + e.getMessage());
        }
    }

    public static void main(String[] args) {
        HaskellInterpreter.installLnF();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                HaskellInterpreter frame = new HaskellInterpreter();
                frame.setDefaultCloseOperation(2);
                frame.setTitle("Haskell Interpreter");
                frame.getContentPane().setPreferredSize(frame.getSize());
                frame.pack();
                frame.setLocationRelativeTo(null);
                frame.setVisible(true);
            }
        });
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        if (arg0.getActionCommand().equals("Run")) {
            try {
                File f = new File("main.exe");
                if (f.exists()) {
                    f.delete();
                    f = new File("main.hs");
                    if (f.exists()) {
                        f.delete();
                    }
                    if ((f = new File("main.hi")).exists()) {
                        f.delete();
                    }
                    if ((f = new File("main.o")).exists()) {
                        f.delete();
                    }
                }
                String fileContents = this.jTextArea0.getText();
                this.jTextField0.setText("");
                this.jTextArea1.setText("");
                this.jTextArea0.validate();
                BufferedWriter bw = new BufferedWriter(new FileWriter("main.hs"));
                bw.write(fileContents);
                bw.close();
                String result = this.evaluateExpression();
                this.jTextField0.setText(result);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public String evaluateExpression() {
        String result = "";
        Runtime run = Runtime.getRuntime();
        try {
            Process comp = run.exec("ghc main.hs");
            comp.waitFor();
            Process p = run.exec("main");
            InputStream is = p.getInputStream();
            BufferedReader br = new BufferedReader(new InputStreamReader(is));
            String linea = "";
            String contents = "";
            linea = br.readLine();
            while (linea != null) {
                this.jTextArea1.setText(String.valueOf(this.jTextArea1.getText()) + linea + "\n");
                contents = linea;
                linea = br.readLine();
            }
            try {
                double d = Double.parseDouble(contents);
                result = "" + d;
            }
            catch (NumberFormatException ex) {
                result = "-1010101010";
            }
            br.close();
        }
        catch (IOException e) {
            if (e.getMessage() != null && e.getMessage().contains("Cannot run program")) {
                JOptionPane.showMessageDialog(null, "The Haskell interpreter is not available, so you cannot run this functionality");
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return result;
    }
}

