/*
 * Decompiled with CFR 0.152.
 */
package languages.properties;

import java.io.FileInputStream;
import java.io.InputStream;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import languages.properties.UnavailablePropertyException;

public class LanguagesPropertiesStore {
    private static final String PROPERTIES_DIR_PATH = "prop/";
    private static final String LANGUAGES_FILE = "languages-properties";
    private static LanguagesPropertiesStore instance;
    private static SortedMap<?, ?> properties;

    private LanguagesPropertiesStore() {
        try {
            Class<LanguagesPropertiesStore> almacenPropiedadesClass = LanguagesPropertiesStore.class;
            ClassLoader classLoader = almacenPropiedadesClass.getClassLoader();
            FileInputStream f = new FileInputStream("prop/languages-properties");
            Properties propiedadesTemporales = new Properties();
            propiedadesTemporales.load(f);
            ((InputStream)f).close();
            properties = new TreeMap<Object, Object>(propiedadesTemporales);
        }
        catch (Exception e) {
            System.err.println("Some exception!");
        }
    }

    public static LanguagesPropertiesStore getInstance() {
        if (instance == null) {
            instance = new LanguagesPropertiesStore();
        }
        return instance;
    }

    public String getProperty(String name) throws UnavailablePropertyException {
        String value = (String)properties.get(name);
        if ((value = value.trim()) == null) {
            throw new UnavailablePropertyException(name);
        }
        return value;
    }

    public Set<String> getPropNamesStartingWith(String name) throws UnavailablePropertyException {
        HashSet<String> propertyNames = new HashSet<String>();
        for (Object o : properties.keySet()) {
            String k = (String)o;
            if (!k.startsWith(name)) continue;
            propertyNames.add(k);
        }
        return propertyNames;
    }

    public List<String> getPropValuesForNamesStartingWith(String name) throws UnavailablePropertyException {
        LinkedList<String> propertyValues = new LinkedList<String>();
        for (Object o : properties.keySet()) {
            String k = (String)o;
            if (!k.startsWith(name)) continue;
            propertyValues.add(this.getProperty(k));
        }
        return propertyValues;
    }
}

