/*
 * Decompiled with CFR 0.152.
 */
package haskell;

import java.awt.Color;
import java.awt.Component;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import languages.properties.LanguagesPropertiesStore;
import languages.properties.UnavailablePropertyException;
import org.dyno.visual.swing.layouts.Constraints;
import org.dyno.visual.swing.layouts.GroupLayout;
import org.dyno.visual.swing.layouts.Leading;

public class HaskellInterpreter
extends JFrame
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private JTextArea inputTxa;
    private JScrollPane jScrollPane0;
    private JTextField jTextField0;
    private JButton runBtn;
    private JTextArea outputTxa;
    private JScrollPane jScrollPane1;
    private JLabel jLabel0;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JMenuItem saveMenuItem;
    private JMenuItem saveAsMenuItem;
    private JMenu jMenu0;
    private JMenuBar jMenuBar0;
    private String currentFile;
    private JMenuItem newMenuItem;
    private JMenuItem openMenuItem;
    private JMenuItem exitMenuItem;
    private String lastSavedText;
    private static String hsPath = "hs_files/";
    private static String outputPath = "output_files/";
    private JLabel noteLbl;
    private JLabel programNameLbl;
    private JTextField programNameTxt;
    private static final String PREFERRED_LOOK_AND_FEEL = "com.sun.java.swing.plaf.nimbus.NimbusLookAndFeel";

    public HaskellInterpreter() {
        try {
            hsPath = LanguagesPropertiesStore.getInstance().getProperty("input-path");
            outputPath = LanguagesPropertiesStore.getInstance().getProperty("output-path");
            this.initComponents();
        }
        catch (UnavailablePropertyException e) {
            e.printStackTrace();
        }
    }

    public HaskellInterpreter(String file) {
        try {
            hsPath = LanguagesPropertiesStore.getInstance().getProperty("input-path");
            outputPath = LanguagesPropertiesStore.getInstance().getProperty("output-path");
            this.currentFile = file;
            this.lastSavedText = "";
            this.initComponents();
        }
        catch (UnavailablePropertyException e) {
            e.printStackTrace();
        }
    }

    private void initComponents() {
        this.setTitle("Haskell Interpreter");
        this.setIconImage(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/Haskell-Logo-Variation.png")));
        this.setResizable(false);
        this.setLayout(new GroupLayout());
        this.add((Component)this.getJScrollPane0(), new Constraints(new Leading(38, 397, 10, 10), new Leading(59, 215, 10, 10)));
        this.add((Component)this.getJLabel0(), new Constraints(new Leading(42, 10, 10), new Leading(25, 12, 12)));
        this.add((Component)this.getJLabel1(), new Constraints(new Leading(527, 10, 10), new Leading(22, 12, 12)));
        this.add((Component)this.getJScrollPane1(), new Constraints(new Leading(516, 333, 10, 10), new Leading(61, 216, 10, 10)));
        this.add((Component)this.getJTextField0(), new Constraints(new Leading(679, 126, 10, 10), new Leading(286, 12, 12)));
        this.add((Component)this.getJLabel2(), new Constraints(new Leading(568, 87, 10, 10), new Leading(292, 12, 12)));
        this.add((Component)this.getJButton0(), new Constraints(new Leading(450, 12, 12), new Leading(138, 10, 10)));
        this.add((Component)this.getNoteLbl(), new Constraints(new Leading(47, 378, 12, 12), new Leading(329, 45, 12, 12)));
        this.add((Component)this.getProgramNameLbl(), new Constraints(new Leading(47, 12, 12), new Leading(299, 10, 10)));
        this.add((Component)this.getProgramNameTxt(), new Constraints(new Leading(156, 135, 10, 10), new Leading(292, 12, 12)));
        this.setJMenuBar(this.getJMenuBar0());
        this.setSize(920, 407);
    }

    private JTextField getProgramNameTxt() {
        if (this.programNameTxt == null) {
            this.programNameTxt = new JTextField();
            this.programNameTxt.setAutoscrolls(true);
        }
        return this.programNameTxt;
    }

    private JLabel getProgramNameLbl() {
        if (this.programNameLbl == null) {
            this.programNameLbl = new JLabel();
            this.programNameLbl.setText("Program Name: ");
        }
        return this.programNameLbl;
    }

    private JLabel getNoteLbl() {
        if (this.noteLbl == null) {
            this.noteLbl = new JLabel();
            this.noteLbl.setFont(new Font("Dialog", 3, 14));
            this.noteLbl.setForeground(Color.red);
            this.noteLbl.setText("<html>The programs or functions cannot accept input instructions such as getLine!<P>");
        }
        return this.noteLbl;
    }

    private JMenuItem getJMenuItem1() {
        if (this.newMenuItem == null) {
            this.newMenuItem = new JMenuItem();
            this.newMenuItem.setText("New...");
            this.newMenuItem.setAccelerator(KeyStroke.getKeyStroke(78, 2));
            this.newMenuItem.addActionListener(this);
        }
        return this.newMenuItem;
    }

    private JMenuItem getJMenuItem2() {
        if (this.openMenuItem == null) {
            this.openMenuItem = new JMenuItem("Open");
            this.openMenuItem.setAccelerator(KeyStroke.getKeyStroke(79, 2));
            this.openMenuItem.addActionListener(this);
        }
        return this.openMenuItem;
    }

    private JMenuItem getJMenuItem3() {
        if (this.exitMenuItem == null) {
            this.exitMenuItem = new JMenuItem("Exit");
            this.exitMenuItem.setAccelerator(KeyStroke.getKeyStroke(69, 2));
            this.exitMenuItem.addActionListener(this);
        }
        return this.exitMenuItem;
    }

    private JMenuBar getJMenuBar0() {
        if (this.jMenuBar0 == null) {
            this.jMenuBar0 = new JMenuBar();
            this.jMenuBar0.add(this.getJMenu0());
        }
        return this.jMenuBar0;
    }

    private JMenu getJMenu0() {
        if (this.jMenu0 == null) {
            this.jMenu0 = new JMenu("File");
            this.jMenu0.add(this.getJMenuItem1());
            this.jMenu0.add(this.getJMenuItem2());
            this.jMenu0.add(this.getJMenuItem0());
            this.jMenu0.add(this.getJMenuItem4());
            this.jMenu0.add(this.getJMenuItem3());
        }
        return this.jMenu0;
    }

    private JMenuItem getJMenuItem0() {
        if (this.saveMenuItem == null) {
            this.saveMenuItem = new JMenuItem("Save");
            this.saveMenuItem.setAccelerator(KeyStroke.getKeyStroke(83, 2));
            this.saveMenuItem.addActionListener(this);
        }
        return this.saveMenuItem;
    }

    private JMenuItem getJMenuItem4() {
        if (this.saveAsMenuItem == null) {
            this.saveAsMenuItem = new JMenuItem("Save As...");
            this.saveAsMenuItem.setAccelerator(KeyStroke.getKeyStroke(65, 2));
            this.saveAsMenuItem.addActionListener(this);
        }
        return this.saveAsMenuItem;
    }

    private JLabel getJLabel2() {
        if (this.jLabel2 == null) {
            this.jLabel2 = new JLabel();
            this.jLabel2.setFont(new Font("Dialog", 0, 14));
            this.jLabel2.setText("End result");
        }
        return this.jLabel2;
    }

    private JLabel getJLabel1() {
        if (this.jLabel1 == null) {
            this.jLabel1 = new JLabel();
            this.jLabel1.setFont(new Font("Dialog", 0, 14));
            this.jLabel1.setText("Output of the Haskell program");
        }
        return this.jLabel1;
    }

    private JLabel getJLabel0() {
        if (this.jLabel0 == null) {
            this.jLabel0 = new JLabel();
            this.jLabel0.setFont(new Font("Arial Narrow", 1, 16));
            this.jLabel0.setText("-- Put your Haskell code here!");
        }
        return this.jLabel0;
    }

    private JScrollPane getJScrollPane1() {
        if (this.jScrollPane1 == null) {
            this.jScrollPane1 = new JScrollPane();
            this.jScrollPane1.setViewportView(this.getJTextArea1());
        }
        return this.jScrollPane1;
    }

    private JTextArea getJTextArea1() {
        if (this.outputTxa == null) {
            this.outputTxa = new JTextArea();
            this.outputTxa.setFont(new Font("Courier New", 1, 14));
            this.outputTxa.setAutoscrolls(true);
        }
        return this.outputTxa;
    }

    private JButton getJButton0() {
        if (this.runBtn == null) {
            this.runBtn = new JButton("Run");
            this.runBtn.setFont(new Font("Dialog", 0, 14));
            this.runBtn.addActionListener(this);
        }
        return this.runBtn;
    }

    private JTextField getJTextField0() {
        if (this.jTextField0 == null) {
            this.jTextField0 = new JTextField();
            this.jTextField0.setFont(new Font("Courier New", 1, 16));
            this.jTextField0.setAutoscrolls(true);
        }
        return this.jTextField0;
    }

    private JScrollPane getJScrollPane0() {
        if (this.jScrollPane0 == null) {
            this.jScrollPane0 = new JScrollPane();
            this.jScrollPane0.setViewportView(this.getJTextArea0());
        }
        return this.jScrollPane0;
    }

    private JTextArea getJTextArea0() {
        if (this.inputTxa == null) {
            this.inputTxa = new JTextArea();
            this.inputTxa.setFont(new Font("Courier New", 1, 14));
            this.inputTxa.setToolTipText("-- Put your Haskell code here!");
            this.inputTxa.setAutoscrolls(true);
        }
        return this.inputTxa;
    }

    private static void installLnF() {
        try {
            String lnfClassname = PREFERRED_LOOK_AND_FEEL;
            if (lnfClassname == null) {
                lnfClassname = UIManager.getCrossPlatformLookAndFeelClassName();
            }
            UIManager.setLookAndFeel(lnfClassname);
        }
        catch (Exception e) {
            System.err.println("Cannot install com.sun.java.swing.plaf.nimbus.NimbusLookAndFeel on this platform:" + e.getMessage());
        }
    }

    public static void main(String[] args) {
        HaskellInterpreter.installLnF();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                HaskellInterpreter frame = new HaskellInterpreter("Untitled.hs");
                frame.setDefaultCloseOperation(2);
                frame.getContentPane().setPreferredSize(frame.getSize());
                frame.pack();
                frame.setLocationRelativeTo(null);
                frame.setVisible(true);
            }
        });
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        block32: {
            if (arg0.getActionCommand().equals("Run")) {
                String filename = this.currentFile = String.valueOf(this.programNameTxt.getText()) + ".hs";
                String name = filename.substring(0, filename.lastIndexOf(".hs"));
                String haskellInterpreter = "ghc";
                try {
                    if (this.lastSavedText == null || !this.lastSavedText.trim().equals(this.inputTxa.getText().trim())) {
                        File f = new File(String.valueOf(outputPath) + name + ".exe");
                        if (f.exists()) {
                            f.delete();
                            f = new File(String.valueOf(hsPath) + name + ".hs");
                            if (f.exists()) {
                                f.delete();
                            }
                            if ((f = new File(String.valueOf(hsPath) + name + ".hi")).exists()) {
                                f.delete();
                            }
                            if ((f = new File(String.valueOf(hsPath) + name + ".o")).exists()) {
                                f.delete();
                            }
                        }
                        String fileContents = this.inputTxa.getText();
                        this.jTextField0.setText("");
                        this.outputTxa.setText("");
                        this.inputTxa.validate();
                        BufferedWriter bw = new BufferedWriter(new FileWriter(String.valueOf(hsPath) + name + ".hs"));
                        bw.write(fileContents);
                        bw.close();
                        Runtime run = Runtime.getRuntime();
                        Process comp = run.exec(String.valueOf(haskellInterpreter) + " " + hsPath + name + ".hs");
                        InputStream is = comp.getErrorStream();
                        BufferedReader br = new BufferedReader(new InputStreamReader(is));
                        String linea = "";
                        String contents = "";
                        linea = br.readLine();
                        while (linea != null) {
                            this.outputTxa.setText(String.valueOf(this.outputTxa.getText()) + linea + "\n");
                            contents = linea;
                            linea = br.readLine();
                        }
                        br.close();
                        File fComp = new File("main.exe");
                        if (fComp.exists()) {
                            fComp.renameTo(new File(String.valueOf(outputPath) + name + ".exe"));
                        }
                    }
                    String result = this.evaluateExpression(name);
                    this.jTextField0.setText(result);
                }
                catch (IOException e) {
                    if (e.getMessage() != null && e.getMessage().contains("Cannot run program \"" + haskellInterpreter + "\"")) {
                        JOptionPane.showMessageDialog(null, "The Haskell interpreter is not available, so you cannot run this functionality");
                    }
                    break block32;
                }
            }
            if (arg0.getActionCommand().equals("Open")) {
                FileDialog dialog = new FileDialog((Frame)this, "Open");
                System.out.println(hsPath);
                dialog.setDirectory(new File(hsPath).getPath());
                System.out.println(dialog.getDirectory());
                dialog.setVisible(true);
                try {
                    String str4 = " ";
                    String str2 = dialog.getFile();
                    if (str2 != null) {
                        String str3 = String.valueOf(hsPath) + str2;
                        File f = new File(str3);
                        FileInputStream fobj = new FileInputStream(f);
                        int len = (int)f.length();
                        int j = 0;
                        while (j < len) {
                            char str5 = (char)fobj.read();
                            str4 = String.valueOf(str4) + str5;
                            ++j;
                        }
                        this.inputTxa.setText(str4);
                        this.programNameTxt.setText(str2.substring(0, str2.lastIndexOf(".hs")));
                    }
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            } else if (arg0.getActionCommand().equals("Save As...")) {
                FileDialog dialog1 = new FileDialog((Frame)this, "Save As", 1);
                dialog1.setVisible(true);
                try {
                    String str7 = dialog1.getDirectory();
                    String str8 = dialog1.getFile();
                    if (str8 != null) {
                        String str9 = String.valueOf(str7) + str8;
                        String str6 = this.inputTxa.getText();
                        int len1 = str6.length();
                        byte[] buf = str6.getBytes();
                        File f1 = new File(str9);
                        FileOutputStream fobj1 = new FileOutputStream(f1);
                        int k = 0;
                        while (k < len1) {
                            fobj1.write(buf[k]);
                            ++k;
                        }
                        fobj1.close();
                        this.currentFile = str8;
                        this.programNameTxt.setText(str8.substring(0, str8.lastIndexOf(".hs")));
                    }
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            } else if (arg0.getActionCommand().equals("Save")) {
                try {
                    String str7 = hsPath;
                    String str8 = String.valueOf(this.programNameTxt.getText()) + ".hs";
                    String str9 = String.valueOf(str7) + str8;
                    String str6 = this.inputTxa.getText();
                    int len1 = str6.length();
                    byte[] buf = str6.getBytes();
                    File f1 = new File(str9);
                    FileOutputStream fobj1 = new FileOutputStream(f1);
                    int k = 0;
                    while (k < len1) {
                        fobj1.write(buf[k]);
                        ++k;
                    }
                    fobj1.close();
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            } else if (arg0.getActionCommand().equals("Exit")) {
                this.dispose();
            }
        }
    }

    public String evaluateExpression(String name) {
        String result;
        block5: {
            result = "";
            Runtime run = Runtime.getRuntime();
            try {
                Process p = run.exec(String.valueOf(outputPath) + name);
                InputStream is = p.getInputStream();
                BufferedReader br = new BufferedReader(new InputStreamReader(is));
                String linea = "";
                String contents = "";
                linea = br.readLine();
                while (linea != null) {
                    this.outputTxa.setText(String.valueOf(this.outputTxa.getText()) + linea + "\n");
                    contents = linea;
                    linea = br.readLine();
                }
                try {
                    double d = Double.parseDouble(contents);
                    result = "" + d;
                }
                catch (NumberFormatException ex) {
                    result = "-1010101010";
                }
                br.close();
            }
            catch (IOException e) {
                if (e.getMessage() == null || !e.getMessage().contains("Cannot run program \"" + name + "\"")) break block5;
                System.out.println(e.getMessage());
                JOptionPane.showMessageDialog(null, "The haskell code contains compilation errors, so the executable file could not be built");
            }
        }
        return result;
    }
}

