/* Generated By:JavaCC: Do not edit this line. PlinguaJavaCcParser.java */
package org.gcn.plinguacore.parser.input.plingua;

import java.io.InputStream;
import java.io.StringReader;
import java.util.List;
import java.util.ArrayList;
import java.util.Stack;
import java.util.Iterator;

import org.gcn.plinguacore.parser.input.byteCounter.InputStreamWrapper;
import org.gcn.plinguacore.parser.input.byteCounter.StringReaderWrapper;
import org.gcn.plinguacore.util.HashMultiSet;
import org.gcn.plinguacore.util.MultiSet;
import org.gcn.plinguacore.util.PlinguaCoreException;
import org.gcn.plinguacore.util.psystem.Label;
import org.gcn.plinguacore.util.psystem.Psystem;
import org.gcn.plinguacore.util.psystem.cellLike.membrane.CellLikeMembrane;
import org.gcn.plinguacore.util.psystem.cellLike.membrane.CellLikeMembraneFactory;
import org.gcn.plinguacore.util.psystem.cellLike.membrane.CellLikeSkinMembrane;
import org.gcn.plinguacore.util.psystem.factory.AbstractPsystemFactory;
import org.gcn.plinguacore.util.psystem.rule.AbstractRuleFactory;
import org.gcn.plinguacore.util.psystem.rule.IStochasticRule;
import org.gcn.plinguacore.util.psystem.rule.InnerRuleMembrane;
import org.gcn.plinguacore.util.psystem.rule.LeftHandRule;
import org.gcn.plinguacore.util.psystem.rule.OuterRuleMembrane;
import org.gcn.plinguacore.util.psystem.rule.RightHandRule;
import org.gcn.plinguacore.util.psystem.rule.IRule;
import org.gcn.plinguacore.util.psystem.rule.spiking.SpikingRule;
import org.gcn.plinguacore.util.psystem.spiking.membrane.SpikingMembrane;
import org.gcn.plinguacore.util.psystem.spiking.membrane.SpikingMembraneStructure;




class PlinguaJavaCcParser extends PlinguaProgram implements PlinguaJavaCcParserConstants {


        private static PlinguaJavaCcParser singleton=null;

        private String expr=null;
        private boolean divisionOrBudding=false;
        private boolean computeEfficiencyAttributes=false;


        private boolean isSpikingPsystem()
        {
                return getPsystem().getAbstractPsystemFactory().getModelName().equals("spiking_psystems");
        }

       private void doSentence(Stack<Token>ranges,Token sentenceToken,PlinguaEnvironment env,boolean execute) throws ParseException
        {
                if (env.getDepthLevel()>0)
                        return;
                if (ranges.isEmpty())
                {
                        if (execute)
                        {
                                Token currentToken=token;
                                token=sentenceToken;
                                jj_ntk=-1;
                                getCurrentEnvironment().disableSafeMode();
                                instruction();
                                getCurrentEnvironment().enableSafeMode();
                                token=currentToken;
                                jj_ntk=-1;
                        }
                }
                else
                {
                        Token rangeToken = ranges.pop();
                        Token currentToken=token;
                        token=rangeToken;
                        jj_ntk=-1;
                        getCurrentEnvironment().disableSafeMode();
                        Range range=range(null);
                        getCurrentEnvironment().enableSafeMode();
                        token=currentToken;
                        jj_ntk=-1;
                        double begin,end;
                        begin=range.beginNumber.doubleValue();
                        end=range.endNumber.doubleValue();

                        if (range.variable==null)
                                doSentence(ranges,sentenceToken,env,execute && begin!=end);
                        else
                        {
                                if (range.firstOperation==Range.LESS_OPERATION) begin++;
                                if (range.secondOperation==Range.LESS_OPERATION) end--;
                                for(double i=begin;i<=end;i++)
                                {
                                        getCurrentEnvironment().disableSafeMode();
                                        env.setVariable(range.variable,getNumber(i));
                                        getCurrentEnvironment().enableSafeMode();
                                        doSentence(ranges,sentenceToken,env,execute);
                                }
                                getCurrentEnvironment().disableSafeMode();
                                env.removeVariable(range.variable);
                                getCurrentEnvironment().enableSafeMode();
                        }
                        ranges.push(rangeToken);

                }

        }





        static class Range {

                public static final boolean LESS_OPERATION=false;
                public static final boolean LESS_OR_EQUAL_OPERATION=true;

                private Number beginNumber;
                private boolean firstOperation;
                private String variable;
                private boolean secondOperation;
                private Number endNumber;
                public Range(Number beginNumber, boolean firstOperation, String variable, boolean secondOperation, Number endNumber) {
                        super();
                        this.beginNumber = beginNumber;
                        this.firstOperation = firstOperation;
                        this.variable = variable;
                        this.secondOperation = secondOperation;
                        this.endNumber = endNumber;
                }


        }

        private static Psystem parse(PlinguaJavaCcParser parser,PlinguaInputParser inputParser) throws PlinguaCoreException
        {
                try
                {
                        parser.reset();
                        parser.setInputParser(inputParser);
                        parser.grammar();
                }
                catch(ParseException ex)
                {
                        parser.writeError(ex);
                }
                catch(TokenMgrError er)
                {
                        parser.writeError(er);
                }
                if (parser.isError())
                        throw new PlinguaCoreException("Parser process finished with errors");

                return parser.getPsystem();
        }

                private static PlinguaJavaCcParser getInstance(InputStream stream)
        {
                        InputStreamWrapper streamWrapper = new InputStreamWrapper(stream);
                if (singleton==null)
                        singleton= new PlinguaJavaCcParser(streamWrapper);
                else
                        singleton.ReInit(streamWrapper);

                byteCounter=streamWrapper;

                return singleton;
        }
        private static PlinguaJavaCcParser getInstance(StringReader reader)
        {
                        StringReaderWrapper readerWrapper= new StringReaderWrapper(reader);
                if (singleton==null)
                        singleton= new PlinguaJavaCcParser(readerWrapper);
                 else
                        singleton.ReInit(readerWrapper);

                byteCounter=readerWrapper;
                return singleton;
        }

        protected static Psystem parse(InputStream stream,PlinguaInputParser inputParser) throws PlinguaCoreException
        {


                return parse(getInstance(stream),inputParser);
        }

        protected static Psystem parse(StringReader reader, PlinguaInputParser inputParser) throws PlinguaCoreException
        {
                return parse(getInstance(reader),inputParser);
        }

        @Override
        protected void doSafeCall(Token callToken) throws ParseException {
                Token returnToken=token;
                token=callToken;
                jj_ntk=-1;
                moduleBody();
                token=returnToken;
                jj_ntk=-1;
        }

  final private String string0() throws ParseException {
                            Token varTokenInit,varTokenEnd;String str;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case STRING:
      jj_consume_token(STRING);
                 {if (true) return token.image.substring(1,token.image.length()-1);}
      break;
    case DOLLAR:
          varTokenInit=token.next;
      str = stringVariable();
                                                        varTokenEnd=token;getCurrentEnvironment().getStringVariable(str,varTokenInit,varTokenEnd);
      break;
    default:
      jj_la1[0] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final private String string() throws ParseException {
                           String str,str1;
    str = string0();
    label_1:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case PLUS:
        ;
        break;
      default:
        jj_la1[1] = jj_gen;
        break label_1;
      }
      jj_consume_token(PLUS);
      str1 = string0();
                               if (!getCurrentEnvironment().isSafeMode())str+=str1;
    }
         {if (true) return str;}
    throw new Error("Missing return statement in function");
  }

  final private String indexes() throws ParseException {
                            Number n;String result;
    jj_consume_token(LBRACE);
    n = number();
                   result="{"+n;
    label_2:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        ;
        break;
      default:
        jj_la1[2] = jj_gen;
        break label_2;
      }
      jj_consume_token(COMMA);
      n = number();
                           result+=","+n;
    }
    jj_consume_token(RBRACE);
                 {if (true) return result+"}";}
    throw new Error("Missing return statement in function");
  }

  final private String numericVariable() throws ParseException {
                                    String result;String indexes="";
    jj_consume_token(ID);
             result=token.image;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LBRACE:
      indexes = indexes();
      break;
    default:
      jj_la1[3] = jj_gen;
      ;
    }
         {if (true) return result+indexes;}
    throw new Error("Missing return statement in function");
  }

  final private String stringVariable() throws ParseException {
                                   String result;
    jj_consume_token(DOLLAR);
                 result=token.image;
    jj_consume_token(ID);
         {if (true) return result+token.image;}
    throw new Error("Missing return statement in function");
  }

  final private Number number0() throws ParseException {
                            Number n;boolean neg=false;String var;Token varTokenInit,varTokenEnd;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case PLUS:
    case MINUS:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case PLUS:
        jj_consume_token(PLUS);
        break;
      case MINUS:
        jj_consume_token(MINUS);
                        neg=true;
        break;
      default:
        jj_la1[4] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
    default:
      jj_la1[5] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case NATURAL_NUMBER:
    case NUMBER:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case NUMBER:
        jj_consume_token(NUMBER);
        break;
      case NATURAL_NUMBER:
        jj_consume_token(NATURAL_NUMBER);
        break;
      default:
        jj_la1[6] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
                                     n = getNumber(Double.parseDouble(token.image));
      break;
    case ID:
          varTokenInit=token.next;
      var = numericVariable();
                                                         varTokenEnd=token;n= getCurrentEnvironment().getNumericVariable(var,varTokenInit,varTokenEnd);
      break;
    case LPAR:
      jj_consume_token(LPAR);
      n = number();
      jj_consume_token(RPAR);
      break;
    default:
      jj_la1[7] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
                if (neg && n!=null)
                        {if (true) return getNumber(-n.doubleValue());}
                else
                        {if (true) return n;}
    throw new Error("Missing return statement in function");
  }

  final private Number number01() throws ParseException {
                             Number n;Stack<Integer> op= new Stack<Integer>();
    label_3:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LOG:
      case FLOOR:
      case CEIL:
        ;
        break;
      default:
        jj_la1[8] = jj_gen;
        break label_3;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LOG:
        jj_consume_token(LOG);
         op.push(1);
        break;
      case CEIL:
        jj_consume_token(CEIL);
                             op.push(2);
        break;
      case FLOOR:
        jj_consume_token(FLOOR);
                                                  op.push(3);
        break;
      default:
        jj_la1[9] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    n = number0();
    if (getCurrentEnvironment().isSafeMode())
    {
        n=null;
        op=null;
    }
    else
    {
        while(!op.isEmpty())
        {
                switch(op.pop())
                {
                        case 1: /* Logaritmo en base 2 */
                                n = getNumber(Math.log(n.doubleValue())/Math.log(2));
                        break;
                        case 2: /* Parte entera por exceso */
                                n= getNumber(Math.ceil(n.doubleValue()));
                        break;
                        case 3: /* Parte entera por defecto */
                                n= getNumber(Math.floor(n.doubleValue()));
                        break;
                }
        }
    }

        {if (true) return n;}
    throw new Error("Missing return statement in function");
  }

  final private Number number1() throws ParseException {
                            Number n1,n2;
    n1 = number01();
    label_4:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case POW:
        ;
        break;
      default:
        jj_la1[10] = jj_gen;
        break label_4;
      }
      jj_consume_token(POW);
      n2 = number01();
                n1 = getCurrentEnvironment().isSafeMode()?null:getNumber(Math.pow(n1.doubleValue(),n2.doubleValue()));
    }
         {if (true) return n1;}
    throw new Error("Missing return statement in function");
  }

  final private Number number2() throws ParseException {
                            Number n1,n2;int op;
    n1 = number1();
    label_5:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case MUL:
      case DIV:
      case MOD:
        ;
        break;
      default:
        jj_la1[11] = jj_gen;
        break label_5;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case MUL:
        jj_consume_token(MUL);
               op=1;
        break;
      case DIV:
        jj_consume_token(DIV);
                            op=2;
        break;
      case MOD:
        jj_consume_token(MOD);
                                         op=3;
        break;
      default:
        jj_la1[12] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      n2 = number1();
                switch (op)
                {
                        case 1:
                                n1 = getCurrentEnvironment().isSafeMode()?null:getNumber(n1.doubleValue()*n2.doubleValue());
                        break;
                        case 2:
                                n1 = getCurrentEnvironment().isSafeMode()?null:getNumber(n1.doubleValue()/n2.doubleValue());
                        break;
                        case 3:
                                n1 = getCurrentEnvironment().isSafeMode()?null:getNumber(n1.doubleValue()%n2.doubleValue());
                        break;
                }
    }
         {if (true) return n1;}
    throw new Error("Missing return statement in function");
  }

  final private Number number() throws ParseException {
                           Number n1,n2;int op;
    n1 = number2();
    label_6:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case PLUS:
      case MINUS:
        ;
        break;
      default:
        jj_la1[13] = jj_gen;
        break label_6;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case PLUS:
        jj_consume_token(PLUS);
                op=1;
        break;
      case MINUS:
        jj_consume_token(MINUS);
                               op=2;
        break;
      default:
        jj_la1[14] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      n2 = number2();
                switch (op)
                {
                        case 1:
                                n1 = getCurrentEnvironment().isSafeMode()?null:getNumber(n1.doubleValue()+n2.doubleValue());
                        break;
                        case 2:
                                n1 = getCurrentEnvironment().isSafeMode()?null:getNumber(n1.doubleValue()-n2.doubleValue());
                        break;
                }
    }
         {if (true) return n1;}
    throw new Error("Missing return statement in function");
  }

  final private String object() throws ParseException {
                           String name,var;Token varTokenInit,varTokenEnd;Number n;String indexes="";
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ID:
    case DOLLAR:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ID:
        jj_consume_token(ID);
               name=token.image;
        break;
      case DOLLAR:
          varTokenInit=token.next;
        var = stringVariable();
                                                        varTokenEnd=token;name=getCurrentEnvironment().getStringVariable(var,varTokenInit,varTokenEnd);
        break;
      default:
        jj_la1[15] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LBRACE:
        indexes = indexes();
        break;
      default:
        jj_la1[16] = jj_gen;
        ;
      }
         {if (true) return name+indexes;}
      break;
    case STRING_OBJECT:
      jj_consume_token(STRING_OBJECT);
                         {if (true) return token.image;}
      break;
    default:
      jj_la1[17] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final private void variantDef() throws ParseException {
        String errorMsg="";
        String model="";
    jj_consume_token(VARIANT);
    jj_consume_token(STRING_OBJECT);
                model= token.image.substring(1,token.image.length()-1);
                try
                {
                        Iterator<String>it=AbstractPsystemFactory.getModelsInfo().getModelsIterator();
                        errorMsg="Was expecting one of these models:\u005cn";
                        while(it.hasNext())
                        {
                                errorMsg+="    * "+it.next();
                                if (it.hasNext())
                                        errorMsg+="\u005cn";
                        }

                        setPsystem(AbstractPsystemFactory.createAbstractPsystemFactory(model).createPsystem());
                        writeInfo("Model = "+model,4);

                }
                catch(Exception ex)
                {
                        throwSemanticsException(ex.getMessage(),token,token,errorMsg);
                }
  }

  final private void param(List<String> params) throws ParseException {
                                           String str;Token paramTokenInit,paramTokenEnd;
         paramTokenInit=token.next;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case DOLLAR:
      str = stringVariable();
      break;
    case ID:
      str = numericVariable();
      break;
    default:
      jj_la1[18] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
                paramTokenEnd=token;
                if (params.contains(str))
                        throwSemanticsException("Repeated parameter '"+str+"'",paramTokenInit,paramTokenEnd);
                params.add(str);
  }

  final private void moduleBody() throws ParseException {
    label_7:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case MULTISET:
      case CALL:
      case LET:
      case MU:
      case MEMB_IN:
      case MEMB_OUT:
      case MARCS:
      case MDICT:
      case MINST:
      case MSEQ:
      case MASYNCH:
      case MVALID:
      case ID:
      case DOLLAR:
      case EMPTY:
      case LBRACE:
      case LSQUARE:
      case LPAR:
      case PLUS:
      case MINUS:
      case DIV:
      case OR:
      case STRING_OBJECT:
      case MOUTRES_BINARY:
      case MOUTRES_NATURAL:
      case MOUTRES_SUMMATORIES:
        ;
        break;
      default:
        jj_la1[19] = jj_gen;
        break label_7;
      }
      sentence();
    }
  }

  final private void moduleDef() throws ParseException {
                            Token moduleNameToken;Token moduleBodyToken;List<String>parameters=new ArrayList<String>();
    jj_consume_token(DEF);
    jj_consume_token(ID);
                  moduleNameToken=token;
    jj_consume_token(LPAR);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ID:
    case DOLLAR:
      param(parameters);
      label_8:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case COMMA:
          ;
          break;
        default:
          jj_la1[20] = jj_gen;
          break label_8;
        }
        jj_consume_token(COMMA);
        param(parameters);
      }
      break;
    default:
      jj_la1[21] = jj_gen;
      ;
    }
    jj_consume_token(RPAR);
    jj_consume_token(LBRACE);
                 moduleBodyToken=token;
                int counter=1;
                Token t=token,t1;
                do{
                        t1=t;
                        t=getNextToken();
                        if (t.kind==LBRACE) counter ++;
                        if (t.kind==RBRACE) counter --;
                        if (t.kind==EOF)
                        {
                                int expected[][]= new int[1][1];
                                expected[0][0] = RBRACE;
                                {if (true) throw new ParseException(t1,expected,tokenImage);}
                        }
                }while(counter!=0 && t.kind!=EOF);
                addModule(moduleNameToken,moduleBodyToken,parameters);
  }

  final private void parameterValue(List parameterValues) throws ParseException {
                                                     Number n;String str;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LOG:
    case FLOOR:
    case CEIL:
    case ID:
    case NATURAL_NUMBER:
    case NUMBER:
    case LPAR:
    case PLUS:
    case MINUS:
      n = number();
                   if (!getCurrentEnvironment().isSafeMode())parameterValues.add(n);
      break;
    case STRING:
    case DOLLAR:
      str = string();
                      if (!getCurrentEnvironment().isSafeMode())parameterValues.add(str);
      break;
    default:
      jj_la1[22] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final private void moduleCall() throws ParseException {
                             Token callToken;List parameterValues=new ArrayList();
    jj_consume_token(CALL);
    jj_consume_token(ID);
                   callToken=token;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LPAR:
      jj_consume_token(LPAR);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LOG:
      case FLOOR:
      case CEIL:
      case STRING:
      case ID:
      case DOLLAR:
      case NATURAL_NUMBER:
      case NUMBER:
      case LPAR:
      case PLUS:
      case MINUS:
        parameterValue(parameterValues);
        label_9:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case COMMA:
            ;
            break;
          default:
            jj_la1[23] = jj_gen;
            break label_9;
          }
          jj_consume_token(COMMA);
          parameterValue(parameterValues);
        }
        break;
      default:
        jj_la1[24] = jj_gen;
        ;
      }
      jj_consume_token(RPAR);
      break;
    default:
      jj_la1[25] = jj_gen;
      ;
    }
         if (!getCurrentEnvironment().isSafeMode()) doCall(callToken.image,callToken,parameterValues);
  }

  final private void multiObject(MultiSet<String> ms) throws ParseException {
                                                 String o;Number mul=1;Token beginObjToken,endObjToken;
                beginObjToken=token.next;
    o = object();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case MUL:
      jj_consume_token(MUL);
      mul = number0();
      break;
    default:
      jj_la1[26] = jj_gen;
      ;
    }
                endObjToken=token;
                try
                {
                        if (!getCurrentEnvironment().isSafeMode())ms.add(o,mul.longValue());
                }catch(Exception ex)
                {
                        throwSemanticsException(ex.getMessage(),beginObjToken,endObjToken);
                }
  }

  final private byte charge() throws ParseException {
                         byte ch=(byte)0;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case MINUS:
      jj_consume_token(MINUS);
                 ch=(byte)-1;
      break;
    case PLUS:
      jj_consume_token(PLUS);
                                      ch=(byte)1;
      break;
    default:
      jj_la1[27] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
                {if (true) return ch;}
    throw new Error("Missing return statement in function");
  }

  final private String labelString() throws ParseException {
                                String r="";Number n=null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ID:
    case DOLLAR:
    case STRING_OBJECT:
      r = object();
      break;
    case NATURAL_NUMBER:
      jj_consume_token(NATURAL_NUMBER);
                          r=token.image;
      break;
    case LBRACE:
      jj_consume_token(LBRACE);
      n = number();
                            if (!getCurrentEnvironment().isSafeMode())r=n.toString();
      jj_consume_token(RBRACE);
      break;
    default:
      jj_la1[28] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
         {if (true) return r;}
    throw new Error("Missing return statement in function");
  }

  final private Label label() throws ParseException {
                         String r1=null,r2=null,r3=null;Label l=null;
    jj_consume_token(QUOTE);
    r1 = labelString();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case COMMA:
      jj_consume_token(COMMA);
      r2 = labelString();
      break;
    default:
      jj_la1[29] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case STRING:
      jj_consume_token(STRING);
                  r3= token.image.substring(1,token.image.length()-1);
      break;
    default:
      jj_la1[30] = jj_gen;
      ;
    }
                if (!getCurrentEnvironment().isSafeMode())
                {
                        if (r2!=null)
                                l = new Label(r1,r2);
                        else
                                l = new Label(r1);
                        expr=r3;
                }
                {if (true) return l;}
    throw new Error("Missing return statement in function");
  }

  final private Label parentLabel(CellLikeMembrane parentMembrane) throws ParseException {
                                                              String r1=null,r2=null;Label l=null;Token beginToken,endToken;
    jj_consume_token(QUOTE);
    r1 = labelString();
         beginToken=token;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case COMMA:
      jj_consume_token(COMMA);
      r2 = labelString();
      break;
    default:
      jj_la1[31] = jj_gen;
      ;
    }
                {endToken=token;}
                if (!getCurrentEnvironment().isSafeMode())
                {
                        if (parentMembrane!=null && !parentMembrane.getLabelObj().getEnvironmentID().equals(""))
                        {
                                if (r2!=null && !r2.equals(parentMembrane.getLabelObj().getEnvironmentID()))
                                        throwSemanticsException("Invalid environment ID",beginToken,endToken);
                                r2=parentMembrane.getLabelObj().getEnvironmentID();
                        }
                        if (r2!=null)
                                l = new Label(r1,r2);
                        else
                                l = new Label(r1);
                }
                {if (true) return l;}
    throw new Error("Missing return statement in function");
  }

  final private Label rsquare() throws ParseException {
                           Label label;
    jj_consume_token(RSQUARE);
    label = label();
                               {if (true) return label;}
    throw new Error("Missing return statement in function");
  }

  final private byte lsquare() throws ParseException {
                          byte ch=(byte)0;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case DIV:
    case OR:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case OR:
        jj_consume_token(OR);
              divisionOrBudding=false;
        break;
      case DIV:
        jj_consume_token(DIV);
                                              divisionOrBudding=true;
        break;
      default:
        jj_la1[32] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
    default:
      jj_la1[33] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case PLUS:
    case MINUS:
      ch = charge();
      break;
    default:
      jj_la1[34] = jj_gen;
      ;
    }
    jj_consume_token(LSQUARE);
                                {if (true) return ch;}
    throw new Error("Missing return statement in function");
  }

  final private CellLikeSkinMembrane cellLikeSkinMembrane() throws ParseException {
                                                       CellLikeMembrane m;
    m = cellLikeMembrane(null);
                {if (true) return (CellLikeSkinMembrane)m;}
    throw new Error("Missing return statement in function");
  }

  final private InnerRuleMembrane innerRuleMembrane() throws ParseException {
        byte ch;
        Label label;
        MultiSet<String> ms = new HashMultiSet<String>();
    ch = lsquare();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ID:
    case DOLLAR:
    case EMPTY:
    case STRING_OBJECT:
      multiSet(ms);
      break;
    default:
      jj_la1[35] = jj_gen;
      ;
    }
    label = rsquare();
         {if (true) return getCurrentEnvironment().isSafeMode()?null:new InnerRuleMembrane(label,ch,ms);}
    throw new Error("Missing return statement in function");
  }

  final private OuterRuleMembrane secondRightOuterRuleMembrane(Label label) throws ParseException {
        byte ch;
        List<InnerRuleMembrane> l = new ArrayList<InnerRuleMembrane>();
        MultiSet<String> ms = new HashMultiSet<String>();
        String obj;
        InnerRuleMembrane im;
    ch = lsquare();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ID:
    case DOLLAR:
    case EMPTY:
    case STRING_OBJECT:
      multiSet(ms);
      break;
    default:
      jj_la1[36] = jj_gen;
      ;
    }
    label_10:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LSQUARE:
      case PLUS:
      case MINUS:
      case DIV:
      case OR:
        ;
        break;
      default:
        jj_la1[37] = jj_gen;
        break label_10;
      }
      im = innerRuleMembrane();
                                if (!getCurrentEnvironment().isSafeMode())l.add(im);
    }
    jj_consume_token(RSQUARE);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case QUOTE:
      label = label();
      break;
    default:
      jj_la1[38] = jj_gen;
      ;
    }
         {if (true) return getCurrentEnvironment().isSafeMode()?null:new OuterRuleMembrane(label,ch,ms,l);}
    throw new Error("Missing return statement in function");
  }

  final private OuterRuleMembraneWithDissolutionOption firstRightOuterRuleMembrane(Label label) throws ParseException {
        byte ch;
        List<InnerRuleMembrane> l = new ArrayList<InnerRuleMembrane>();
        MultiSet<String> ms = new HashMultiSet<String>();
        InnerRuleMembrane im;
        boolean dissolves=false;
    ch = lsquare();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case DISSOLVES:
    case ID:
    case DOLLAR:
    case EMPTY:
    case STRING_OBJECT:
      dissolves = multiSetWithDissolutionOption(ms);
      break;
    default:
      jj_la1[39] = jj_gen;
      ;
    }
    label_11:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LSQUARE:
      case PLUS:
      case MINUS:
      case DIV:
      case OR:
        ;
        break;
      default:
        jj_la1[40] = jj_gen;
        break label_11;
      }
      im = innerRuleMembrane();
                                if (!getCurrentEnvironment().isSafeMode())l.add(im);
    }
    jj_consume_token(RSQUARE);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case QUOTE:
      label = label();
      break;
    default:
      jj_la1[41] = jj_gen;
      ;
    }
         {if (true) return getCurrentEnvironment().isSafeMode()?null:new OuterRuleMembraneWithDissolutionOption(label,ch,ms,l,dissolves);}
    throw new Error("Missing return statement in function");
  }

  final private List<InnerRuleMembrane> innerRuleMembranes() throws ParseException {
        List<InnerRuleMembrane> l = new ArrayList<InnerRuleMembrane>();
        InnerRuleMembrane im;
    label_12:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LSQUARE:
      case PLUS:
      case MINUS:
      case DIV:
      case OR:
        ;
        break;
      default:
        jj_la1[42] = jj_gen;
        break label_12;
      }
      im = innerRuleMembrane();
                                if (!getCurrentEnvironment().isSafeMode())l.add(im);
    }
         {if (true) return l;}
    throw new Error("Missing return statement in function");
  }

  final private OuterRuleMembrane outerRuleMembrane() throws ParseException {
        byte ch;
        Label label;
        List<InnerRuleMembrane> l;
        MultiSet<String> ms = new HashMultiSet<String>();
    ch = lsquare();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ID:
    case DOLLAR:
    case EMPTY:
    case STRING_OBJECT:
      multiSet(ms);
      break;
    default:
      jj_la1[43] = jj_gen;
      ;
    }
    l = innerRuleMembranes();
    label = rsquare();
         {if (true) return getCurrentEnvironment().isSafeMode()?null:new OuterRuleMembrane(label,ch,ms,l);}
    throw new Error("Missing return statement in function");
  }

  final private CellLikeMembrane cellLikeMembrane(CellLikeMembrane parentMembrane) throws ParseException {
        Label label;
        byte ch;
        Token initToken,init=null,end=null;
        CellLikeMembrane m=null;
        MultiSet<String> ms = new HashMultiSet<String>();
    ch = lsquare();
                initToken=token;
                int counter=1;
                Token t=token,t1;
                do{
                        t1=t;
                        t=getNextToken();
                        if (t.kind==LSQUARE) counter ++;
                        if (t.kind==RSQUARE) counter --;
                        if (t.kind==EOF || t.kind==SEPARATOR)
                        {
                                int expected[][]= new int[1][1];
                                expected[0][0] = RSQUARE;
                                if (t.kind==SEPARATOR) token=t1;
                                {if (true) throw new ParseException(t1,expected,tokenImage);}
                        }

                }while(counter!=0 && t.kind!=EOF && t.kind!=SEPARATOR);
         init=token;
    label = parentLabel(parentMembrane);
         end=token;
                token=initToken;
                jj_ntk=-1;
                if (!getCurrentEnvironment().isSafeMode())
                {
                        m = CellLikeMembraneFactory.getCellLikeMembrane(label,parentMembrane);
                        m.setCharge(ch);
                        ms=m.getMultiSet();
                }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ID:
    case DOLLAR:
    case EMPTY:
    case STRING_OBJECT:
      multiSet(ms);
      break;
    default:
      jj_la1[44] = jj_gen;
      ;
    }
    label_13:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LSQUARE:
      case PLUS:
      case MINUS:
      case DIV:
      case OR:
        ;
        break;
      default:
        jj_la1[45] = jj_gen;
        break label_13;
      }
      cellLikeMembrane(m);
    }
    rsquare();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case QUOTE:
      label();
      break;
    default:
      jj_la1[46] = jj_gen;
      ;
    }
              if (!getCurrentEnvironment().isSafeMode() && !label.getEnvironmentID().equals(""))
                        addMembrane(label.getLabelID(),label.getEnvironmentID(),m,init,end);

        {if (true) return m;}
    throw new Error("Missing return statement in function");
  }

  final private boolean multiSetWithDissolutionOption(MultiSet<String> ms) throws ParseException {
        boolean dissolves=false;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case DISSOLVES:
    case ID:
    case DOLLAR:
    case STRING_OBJECT:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ID:
      case DOLLAR:
      case STRING_OBJECT:
        multiObject(ms);
        break;
      case DISSOLVES:
        jj_consume_token(DISSOLVES);
                                      dissolves=true;
        break;
      default:
        jj_la1[47] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      label_14:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case COMMA:
          ;
          break;
        default:
          jj_la1[48] = jj_gen;
          break label_14;
        }
        jj_consume_token(COMMA);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case ID:
        case DOLLAR:
        case STRING_OBJECT:
          multiObject(ms);
          break;
        case DISSOLVES:
          jj_consume_token(DISSOLVES);
                                             dissolves=true;
          break;
        default:
          jj_la1[49] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
      break;
    case EMPTY:
      jj_consume_token(EMPTY);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        jj_consume_token(COMMA);
        jj_consume_token(DISSOLVES);
                                    dissolves=true;
        break;
      default:
        jj_la1[50] = jj_gen;
        ;
      }
      break;
    default:
      jj_la1[51] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
         {if (true) return dissolves;}
    throw new Error("Missing return statement in function");
  }

  final private void multiSet(MultiSet<String> ms) throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ID:
    case DOLLAR:
    case STRING_OBJECT:
      multiObject(ms);
      label_15:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case COMMA:
          ;
          break;
        default:
          jj_la1[52] = jj_gen;
          break label_15;
        }
        jj_consume_token(COMMA);
        multiObject(ms);
      }
      break;
    case EMPTY:
      jj_consume_token(EMPTY);
      break;
    default:
      jj_la1[53] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final private void multiSetAsig() throws ParseException {
                               MultiSet ms=new HashMultiSet<String>();boolean inc=false;String label="";String id=null;Token init=null,end=null;
    jj_consume_token(MULTISET);
    jj_consume_token(LPAR);
                         init=token;
    label = labelString();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case COMMA:
      jj_consume_token(COMMA);
      id = labelString();
      break;
    default:
      jj_la1[54] = jj_gen;
      ;
    }
                                                                                    end=token;
    jj_consume_token(RPAR);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case INC:
      jj_consume_token(INC);
                                                                                                             inc=true;
      break;
    case ASIG:
      jj_consume_token(ASIG);
      break;
    default:
      jj_la1[55] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    multiSet(ms);
                if (!getCurrentEnvironment().isSafeMode())
                {
                        if (id==null)
                        {
                                if (!inc || !getPsystem().getInitialMultiSets().containsKey(label))
                                        getPsystem().getInitialMultiSets().put(label,ms);
                                else
                                {
                                        MultiSet ms1=getPsystem().getInitialMultiSets().get(label);
                                        ms1.addAll(ms);
                                }
                        }
                        else
                        {
                                addMultiSet(label,id,ms,inc,init,end);
                        }
                }
  }

  final private void labelsList() throws ParseException {
                             String label;
    label = labelString();
                if (!getCurrentEnvironment().isSafeMode())
                {
                        if (!isSpikingPsystem())
                                throwSemanticsException("Invalid initial configuration",token,token);
                        else
                        {
                                SpikingMembrane.buildMembrane
                                (label,0L,(SpikingMembraneStructure)getPsystem().getMembraneStructure(),computeEfficiencyAttributes);
                        }
                }
    label_16:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        ;
        break;
      default:
        jj_la1[56] = jj_gen;
        break label_16;
      }
      jj_consume_token(COMMA);
      label = labelString();
                        if (!getCurrentEnvironment().isSafeMode())
                        {
                                if (!isSpikingPsystem())
                                        throwSemanticsException("Invalid initial configuration specification",token,token);
                        else
                        {
                                SpikingMembrane.buildMembrane
                                (label,0L,(SpikingMembraneStructure)getPsystem().getMembraneStructure(),computeEfficiencyAttributes);
                        }
                }
    }
  }

  final private void mout() throws ParseException {
    jj_consume_token(MEMB_OUT);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ASIG:
      jj_consume_token(ASIG);
      break;
    case INC:
      jj_consume_token(INC);
      break;
    default:
      jj_la1[57] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ID:
    case DOLLAR:
    case NATURAL_NUMBER:
    case LBRACE:
    case STRING_OBJECT:
      mout_element();
      label_17:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case COMMA:
          ;
          break;
        default:
          jj_la1[58] = jj_gen;
          break label_17;
        }
        jj_consume_token(COMMA);
        mout_element();
      }
      break;
    default:
      jj_la1[59] = jj_gen;
      ;
    }
  }

  final private void mout_element() throws ParseException {
                               String l;
    l = labelString();
                if (!getCurrentEnvironment().isSafeMode())
                {
                        if (!isSpikingPsystem())
                                throwSemanticsException("Invalid sentence",token,token);
                        else
                        {
                                try
                                {
                                        ((SpikingMembraneStructure)getPsystem().getMembraneStructure()).setOutputMembrane(l,false);
                                        writeInfo("Setting output membrane: "+l,4);

                                }
                                catch(Exception ex)
                                {
                                        throwSemanticsException(ex.getMessage(),token,token);
                                }
                        }
                }
  }

  final private void min() throws ParseException {
                      String l;
    jj_consume_token(MEMB_IN);
    jj_consume_token(ASIG);
    l = labelString();
                if (!getCurrentEnvironment().isSafeMode())
                {
                        if (!isSpikingPsystem())
                                throwSemanticsException("Invalid sentence",token,token);
                        else
                        {
                                try
                                {
                                        ((SpikingMembraneStructure)getPsystem().getMembraneStructure()).setInputMembrane(l,false);
                                        writeInfo("Setting input membrane: "+l,4);

                                }
                                catch(Exception ex)
                                {
                                        throwSemanticsException(ex.getMessage(),token,token);
                                }
                        }
                }
  }

  final private void mdict() throws ParseException {
    jj_consume_token(MDICT);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ASIG:
      jj_consume_token(ASIG);
      break;
    case INC:
      jj_consume_token(INC);
      break;
    default:
      jj_la1[60] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LPAR:
      mdict_element();
      label_18:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case COMMA:
          ;
          break;
        default:
          jj_la1[61] = jj_gen;
          break label_18;
        }
        jj_consume_token(COMMA);
        mdict_element();
      }
      break;
    default:
      jj_la1[62] = jj_gen;
      ;
    }
  }

  final private void mdict_element() throws ParseException {
                                String l1,l2;
    jj_consume_token(LPAR);
    l1 = labelString();
    jj_consume_token(COMMA);
    l2 = labelString();
    jj_consume_token(RPAR);
                if (!getCurrentEnvironment().isSafeMode())
                {
                        if (!isSpikingPsystem())
                                throwSemanticsException("Invalid sentence",token,token);
                        else
                        {
                                try
                                {
                                ((SpikingMembraneStructure)getPsystem().getMembraneStructure()).updateDictionary(l1,l2);
                                writeInfo("Updating dictionary: ("+l1+", "+l2+")",4);
                                }catch(Exception ex)
                                {
                                        throwSemanticsException(ex.getMessage(),token,token);
                                }
                        }
                }
  }

  final private void minst() throws ParseException {
    jj_consume_token(MINST);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ASIG:
      jj_consume_token(ASIG);
      break;
    case INC:
      jj_consume_token(INC);
      break;
    default:
      jj_la1[63] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LPAR:
      minst_element();
      label_19:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case COMMA:
          ;
          break;
        default:
          jj_la1[64] = jj_gen;
          break label_19;
        }
        jj_consume_token(COMMA);
        minst_element();
      }
      break;
    default:
      jj_la1[65] = jj_gen;
      ;
    }
  }

  final private void minst_element() throws ParseException {
                                Number a,b;
    jj_consume_token(LPAR);
    a = number();
    jj_consume_token(COMMA);
    b = number();
    jj_consume_token(RPAR);
                if (!getCurrentEnvironment().isSafeMode())
                {
                        if (!isSpikingPsystem())
                                throwSemanticsException("Invalid sentence",token,token);
                        else
                        {
                                try
                                {

                                if( ( (double) a.longValue() ) != a.doubleValue())
                                        {if (true) throw new Exception("time parameter must can be cast to long");}

                                if( ( (double) b.longValue() ) != b.doubleValue())
                                        {if (true) throw new Exception("spikes parameter must can be cast to long");}

                                if(a.longValue() < 1L)
                                        {if (true) throw new Exception("time parameter must be greater or equal than one");}

                                if(b.longValue() < 0L)
                                        {if (true) throw new Exception("time parameter must be greater or equal than zero");}

                                ((SpikingMembraneStructure)getPsystem().getMembraneStructure()).
                                        getEnvironmentMembrane().getInputSequence().put(a.longValue(),b.longValue());
                                writeInfo("Updating input sequence: ("+a.longValue()+", "+b.longValue()+")",4);
                                }catch(Exception ex)
                                {
                                        throwSemanticsException(ex.getMessage(),token,token);
                                }
                        }
                }
  }

  final private void mseq() throws ParseException {
                       Number a;
    jj_consume_token(MSEQ);
    jj_consume_token(ASIG);
    a = number();
                if (!getCurrentEnvironment().isSafeMode())
                {
                        if (!isSpikingPsystem())
                                throwSemanticsException("Invalid sentence",token,token);
                        else
                        {
                                try
                                {

                                if( ( (double) a.longValue() ) != a.doubleValue())
                                        {if (true) throw new Exception("Sequential Mode must can be cast to int");}

                                if(a.longValue() < 0L || a.longValue() > 5L)
                                        {if (true) throw new Exception("Sequential Mode must be in [0,1,2,3,4,5]");}

                                ((SpikingMembraneStructure)getPsystem().getMembraneStructure()).
                                        setSequentialMode((int) a.longValue());
                                writeInfo("Updating Sequential Mode: ("+a.longValue()+")",4);
                                }catch(Exception ex)
                                {
                                        throwSemanticsException(ex.getMessage(),token,token);
                                }
                        }
                }
  }

  final private void masynch() throws ParseException {
                          Number a;
    jj_consume_token(MASYNCH);
    jj_consume_token(ASIG);
    a = number();
                if (!getCurrentEnvironment().isSafeMode())
                {
                        if (!isSpikingPsystem())
                                throwSemanticsException("Invalid sentence",token,token);
                        else
                        {
                                try
                                {

                                if( ( (double) a.longValue() ) != a.doubleValue())
                                        {if (true) throw new Exception("Asynch Mode must can be cast to int");}

                                if(a.longValue() < 0L || a.longValue() > 2L)
                                        {if (true) throw new Exception("Sequential Mode must be in [0,1,2]");}

                                ((SpikingMembraneStructure)getPsystem().getMembraneStructure()).
                                        setAsynchMode((int) a.longValue());
                                writeInfo("Updating Asynch Mode: ("+a.longValue()+")",4);
                                }catch(Exception ex)
                                {
                                        throwSemanticsException(ex.getMessage(),token,token);
                                }
                        }
                }
  }

  final private void mvalid() throws ParseException {
    jj_consume_token(MVALID);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ASIG:
      jj_consume_token(ASIG);
      break;
    case INC:
      jj_consume_token(INC);
      break;
    default:
      jj_la1[66] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LPAR:
      mvalid_element();
      label_20:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case COMMA:
          ;
          break;
        default:
          jj_la1[67] = jj_gen;
          break label_20;
        }
        jj_consume_token(COMMA);
        mvalid_element();
      }
      break;
    default:
      jj_la1[68] = jj_gen;
      ;
    }
  }

  final private void mvalid_element() throws ParseException {
                                 String l;Number n;
    jj_consume_token(LPAR);
    l = labelString();
    jj_consume_token(COMMA);
    n = number();
    jj_consume_token(RPAR);
                if (!getCurrentEnvironment().isSafeMode())
                {
                        if (!isSpikingPsystem())
                                throwSemanticsException("Invalid sentence",token,token);
                        else
                        {
                                try
                                {

                                if( ( (double) n.longValue() ) != n.doubleValue())
                                        {if (true) throw new Exception("Asynch Mode must can be cast to long");}

                                if(n.longValue() < 0L)
                                        {if (true) throw new Exception("Valid value must greater or equal than zero");}

                                ((SpikingMembraneStructure)getPsystem().getMembraneStructure()).
                                        updateAsynchValidConfiguration(l,n.longValue());
                                writeInfo("Updating Asynch Valid Configuration: ("+l+", "+n.longValue()+")",4);
                                }catch(Exception ex)
                                {
                                        throwSemanticsException(ex.getMessage(),token,token);
                                }
                        }
                }
  }

  final private void marcs() throws ParseException {
    jj_consume_token(MARCS);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ASIG:
      jj_consume_token(ASIG);
      break;
    case INC:
      jj_consume_token(INC);
      break;
    default:
      jj_la1[69] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LPAR:
      marcs_element();
      label_21:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case COMMA:
          ;
          break;
        default:
          jj_la1[70] = jj_gen;
          break label_21;
        }
        jj_consume_token(COMMA);
        marcs_element();
      }
      break;
    default:
      jj_la1[71] = jj_gen;
      ;
    }
  }

  final private void marcs_element() throws ParseException {
                                String l1,l2;
    jj_consume_token(LPAR);
    l1 = labelString();
    jj_consume_token(COMMA);
    l2 = labelString();
    jj_consume_token(RPAR);
                if (!getCurrentEnvironment().isSafeMode())
                {
                        if (!isSpikingPsystem())
                                throwSemanticsException("Invalid sentence",token,token);
                        else
                        {
                                try
                                {
                                ((SpikingMembraneStructure)getPsystem().getMembraneStructure()).connect(l1,l2);
                                writeInfo("Connecting arcs: ("+l1+", "+l2+")",4);
                                }catch(Exception ex)
                                {
                                        throwSemanticsException(ex.getMessage(),token,token);
                                }
                        }
                }
  }

  final private void moutres_binary() throws ParseException {
    jj_consume_token(MOUTRES_BINARY);
                if (!getCurrentEnvironment().isSafeMode())
                {
                        if (!isSpikingPsystem())
                                throwSemanticsException("Invalid sentence",token,token);
                        else
                        {
                                try
                                {
                                ((SpikingMembraneStructure)getPsystem().getMembraneStructure()).
                                        setShowBinarySequence(true);
                                writeInfo("Setting Binary Sequence to be shown... ",4);
                                }catch(Exception ex)
                                {
                                        throwSemanticsException(ex.getMessage(),token,token);
                                }
                        }
                }
  }

  final private void moutres_summatories() throws ParseException {
    jj_consume_token(MOUTRES_SUMMATORIES);
                if (!getCurrentEnvironment().isSafeMode())
                {
                        if (!isSpikingPsystem())
                                throwSemanticsException("Invalid sentence",token,token);
                        else
                        {
                                try
                                {
                                ((SpikingMembraneStructure)getPsystem().getMembraneStructure()).
                                        setShowSummatories(true);
                                writeInfo("Setting Summatories to be shown... ",4);
                                }catch(Exception ex)
                                {
                                        throwSemanticsException(ex.getMessage(),token,token);
                                }
                        }
                }
  }

  final private void moutres_natural() throws ParseException {
                                  Number n; String s1,s2;boolean b1,b2;ArrayList array;
    jj_consume_token(MOUTRES_NATURAL);
    jj_consume_token(LPAR);
    n = number();
    jj_consume_token(COMMA);
    s1 = labelString();
    jj_consume_token(COMMA);
    s2 = labelString();
    jj_consume_token(RPAR);
                if (!getCurrentEnvironment().isSafeMode())
                {
                        if (!isSpikingPsystem())
                                throwSemanticsException("Invalid sentence",token,token);
                        else
                        {
                                try
                                {

                                if( ( (double) n.longValue() ) != n.doubleValue())
                                        {if (true) throw new Exception("k must can be cast to long");}

                                if(n.longValue() < 2L)
                                        {if (true) throw new Exception("k must be greater or equal to two");}

                                if(s1.toLowerCase().equals("true") == true)
                                        b1 = true;
                                else if (s1.toLowerCase().equals("false") == true)
                                        b1 = false;
                                else
                                        {if (true) throw new Exception("The strong parameter must be boolean");}

                                if(s2.toLowerCase().equals("true") == true)
                                        b2 = true;
                                else if (s2.toLowerCase().equals("false") == true)
                                        b2 = false;
                                else
                                        {if (true) throw new Exception("The alternate parameter must be boolean");}


                                array = new ArrayList();
                                array.add(n.longValue());
                                array.add(b1);
                                array.add(b2);

                                ((SpikingMembraneStructure)getPsystem().getMembraneStructure()).
                                        setShowNaturalSequence(array);
                                writeInfo("Setting Natural Sequence to be shown...",4);

                                }catch(Exception ex)
                                {
                                        throwSemanticsException(ex.getMessage(),token,token);
                                }
                        }
                }
  }

  final private void initConfiguration() throws ParseException {
                                    CellLikeSkinMembrane m=null;
    jj_consume_token(MU);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ASIG:
      jj_consume_token(ASIG);
      break;
    case INC:
      jj_consume_token(INC);
      break;
    default:
      jj_la1[72] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LSQUARE:
    case PLUS:
    case MINUS:
    case DIV:
    case OR:
      m = cellLikeSkinMembrane();
      break;
    case ID:
    case DOLLAR:
    case NATURAL_NUMBER:
    case LBRACE:
    case STRING_OBJECT:
      labelsList();
      break;
    default:
      jj_la1[73] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
                if (!getCurrentEnvironment().isSafeMode() && m!=null)
                {

                        getPsystem().setMembraneStructure(m);
                }
  }

  final private Number priority() throws ParseException {
        Number n;
    jj_consume_token(LPAR);
    n = number();
    jj_consume_token(RPAR);
         {if (true) return n;}
    throw new Error("Missing return statement in function");
  }

  final private void rule() throws ParseException {
        MultiSet<String> leftMultiSet=new HashMultiSet<String>();
        MultiSet<String> rightMultiSet=new HashMultiSet<String>();
        MultiSet<String> leftOuterRuleMembraneMultiSet=new HashMultiSet<String>();
        MultiSet<String> rightOuterRuleMembraneMultiSet=new HashMultiSet<String>();
        List<InnerRuleMembrane> leftInner,rightInner;
        String errorCauses="";
        OuterRuleMembraneWithDissolutionOption firstRightOuterRuleMembrane=null;
        OuterRuleMembrane leftOuterRuleMembrane=null,secondRightOuterRuleMembrane=null;
        Number ratio=0,priority=0;
        boolean hasPriority=false,hasRatio=false;
        Token beginRuleToken,endRuleToken;
        IRule r;
        byte ch;
        Label label;
        boolean dissolves=false,doubleArrow=false;
         beginRuleToken=token.next;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LPAR:
      priority = priority();
                              hasPriority=true;
      break;
    default:
      jj_la1[74] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ID:
    case DOLLAR:
    case EMPTY:
    case STRING_OBJECT:
      multiSet(leftMultiSet);
      break;
    default:
      jj_la1[75] = jj_gen;
      ;
    }
    ch = lsquare();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ID:
    case DOLLAR:
    case EMPTY:
    case STRING_OBJECT:
      multiSet(leftOuterRuleMembraneMultiSet);
      break;
    default:
      jj_la1[76] = jj_gen;
      ;
    }
    leftInner = innerRuleMembranes();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case RSQUARE:
      label = rsquare();
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ARROW:
        jj_consume_token(ARROW);
        break;
      case DOUBLE_ARROW:
        jj_consume_token(DOUBLE_ARROW);
                                 doubleArrow=true;
        break;
      default:
        jj_la1[77] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
                                                     if (!getCurrentEnvironment().isSafeMode())firstRightOuterRuleMembrane=new OuterRuleMembraneWithDissolutionOption(label,ch,true);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ID:
      case DOLLAR:
      case EMPTY:
      case STRING_OBJECT:
        multiSet(rightMultiSet);
        break;
      default:
        jj_la1[78] = jj_gen;
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LSQUARE:
      case PLUS:
      case MINUS:
      case DIV:
      case OR:
        firstRightOuterRuleMembrane = firstRightOuterRuleMembrane(label);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case LSQUARE:
        case PLUS:
        case MINUS:
        case DIV:
        case OR:
          secondRightOuterRuleMembrane = secondRightOuterRuleMembrane(label);
          break;
        default:
          jj_la1[79] = jj_gen;
          ;
        }
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case ID:
        case DOLLAR:
        case EMPTY:
        case STRING_OBJECT:
          multiSet(rightMultiSet);
          break;
        default:
          jj_la1[80] = jj_gen;
          ;
        }
        break;
      default:
        jj_la1[81] = jj_gen;
        ;
      }
      break;
    case ARROW:
      jj_consume_token(ARROW);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case DISSOLVES:
      case ID:
      case DOLLAR:
      case EMPTY:
      case STRING_OBJECT:
        dissolves = multiSetWithDissolutionOption(rightOuterRuleMembraneMultiSet);
        break;
      default:
        jj_la1[82] = jj_gen;
        ;
      }
      rightInner = innerRuleMembranes();
      label = rsquare();
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case DEBUG:
        jj_consume_token(DEBUG);
        string();
        break;
      default:
        jj_la1[83] = jj_gen;
        ;
      }
 if (!getCurrentEnvironment().isSafeMode())firstRightOuterRuleMembrane=new OuterRuleMembraneWithDissolutionOption(label,ch,rightOuterRuleMembraneMultiSet,rightInner,dissolves);
      break;
    default:
      jj_la1[84] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case DOUBLE_COLON:
      jj_consume_token(DOUBLE_COLON);
      ratio = number();
                                      hasRatio=true;
      break;
    default:
      jj_la1[85] = jj_gen;
      ;
    }
                if (!getCurrentEnvironment().isSafeMode())
                {
                        endRuleToken=token;
                        leftOuterRuleMembrane=new OuterRuleMembrane(label,ch,leftOuterRuleMembraneMultiSet,leftInner);
                        LeftHandRule leftHandRule;
                        RightHandRule rightHandRule;
                        if (hasPriority && hasRatio)
                                throwSemanticsException("A rule cannot define a ratio and a priority at once",beginRuleToken,endRuleToken);
                        leftHandRule = new LeftHandRule(leftOuterRuleMembrane,leftMultiSet);
                        if (secondRightOuterRuleMembrane==null)
                                rightHandRule = new RightHandRule(firstRightOuterRuleMembrane,rightMultiSet);
                        else
                                rightHandRule = new RightHandRule(firstRightOuterRuleMembrane,secondRightOuterRuleMembrane,rightMultiSet);
                        try
                        {
                                AbstractRuleFactory factory=getPsystem().getAbstractPsystemFactory().getRuleFactory();
                                if (doubleArrow)
                                   r = factory.createDoubleCommunicationRule(firstRightOuterRuleMembrane
                                                        .dissolves(), leftHandRule, rightHandRule);
                                else
                                if (hasPriority)
                                        r = factory.createPriorityRule(firstRightOuterRuleMembrane
                                                        .dissolves(), leftHandRule, rightHandRule, priority
                                                        .intValue());
                                 else if (getPsystem().getAbstractPsystemFactory().getModelName()
                                                             .equals("spiking_psystems"))
                                {
                                        String type=null;
                                        if (!divisionOrBudding)
                                                type="division";
                                        else
                                                type="budding";
                                        r = SpikingRule.buildRule(leftHandRule, rightHandRule, expr, ratio.longValue(), type,computeEfficiencyAttributes);
                                }
                                else if (hasRatio) {
                                        r = factory.createConstantRule(firstRightOuterRuleMembrane
                                                        .dissolves(), leftHandRule, rightHandRule, ratio
                                                        .floatValue());

                                        if (getPsystem().getAbstractPsystemFactory().getModelName()
                                                        .equals("stochastic") &&
                                                        !noGeneStringsCheckRule.checkRule(r))
                                                r = (IStochasticRule)r;

                                        if (getPsystem().getAbstractPsystemFactory().getModelName()
                                                        .equals("probabilistic")) {
                                                if (ratio.floatValue() == 0) {
                                                        writeWarning("Rule ignored: " + r, beginRuleToken,
                                                                        endRuleToken);
                                                        r = null;
                                                }
                                        }
                                } else
                                        r = factory.createBasicRule(firstRightOuterRuleMembrane
                                                        .dissolves(), leftHandRule, rightHandRule);

                                if (r != null) {

                                        if (!getPsystem().getRules().checkRule(r)) {
                                                errorCauses = getPsystem().getRules().getCheckRule()
                                                                .getCausesString();
                                                {
                                                        if (true)
                                                                {if (true) throw new Exception("Rule doesn't match the \u005c""
                                                                                + getPsystem()
                                                                                                .getAbstractPsystemFactory()
                                                                                                .getModelName()
                                                                                + "\u005c" specification");}
                                                }
                                        }

                                        if (getPsystem().getRules().contains(r))
                                                writeWarning("Repeated rule: " + r, beginRuleToken,
                                                                endRuleToken);
                                        else {
                                                countRules++;
                        writeInfo("Adding rule #"+countRules+": " + r, 4);
                        getPsystem().addRule(r);
                                        }
                                }
                        }
                        catch(Exception ex)
                        {
                                throwSemanticsException(ex.getMessage(),beginRuleToken,endRuleToken,errorCauses);
                        }
                }
  }

  final private void assignment() throws ParseException {
                             String var,str;Number n;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case DOLLAR:
      var = stringVariable();
      jj_consume_token(ASIG);
      str = string();
                                               getCurrentEnvironment().setVariable(var,str);
      break;
    case ID:
      var = numericVariable();
      jj_consume_token(ASIG);
      n = number();
                                               getCurrentEnvironment().setVariable(var,n);
      break;
    default:
      jj_la1[86] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final private Range range(Stack<Token>ranges) throws ParseException {
        Number n1=null,n2=null;
        boolean op1=Range.LESS_OR_EQUAL_OPERATION,op2=Range.LESS_OR_EQUAL_OPERATION,diff=false;
        String variable=null;
        Token rangeToken;
         rangeToken=token;
    n1 = number();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case DIFF:
      jj_consume_token(DIFF);
                       diff=true;
      break;
    case LESS_THAN:
    case LESS_OR_EQUAL_THAN:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LESS_THAN:
        jj_consume_token(LESS_THAN);
                             op1=Range.LESS_OPERATION;
        break;
      case LESS_OR_EQUAL_THAN:
        jj_consume_token(LESS_OR_EQUAL_THAN);
        break;
      default:
        jj_la1[87] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      jj_consume_token(ID);
                     variable=token.image;
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LESS_THAN:
        jj_consume_token(LESS_THAN);
                             op2=Range.LESS_OPERATION;
        break;
      case LESS_OR_EQUAL_THAN:
        jj_consume_token(LESS_OR_EQUAL_THAN);
        break;
      default:
        jj_la1[88] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
    default:
      jj_la1[89] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    n2 = number();
                if (ranges!=null)
                {
                        if (!diff)
                                ranges.push(rangeToken);
                        else
                                ranges.add(0,rangeToken);

                }

                {if (true) return getCurrentEnvironment().isSafeMode()?null:new Range(n1,op1,variable,op2,n2);}
    throw new Error("Missing return statement in function");
  }

  final private void sentence() throws ParseException {
        Token sentenceToken;
        Stack<Token>ranges=new Stack<Token>();
    try {
                        getCurrentEnvironment().incDepthLevel();
                        sentenceToken=token;
                        getCurrentEnvironment().enableSafeMode();
      instruction();
                        getCurrentEnvironment().decDepthLevel();
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COLON:
        jj_consume_token(COLON);
        range(ranges);
        label_22:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case COMMA:
            ;
            break;
          default:
            jj_la1[90] = jj_gen;
            break label_22;
          }
          jj_consume_token(COMMA);
          range(ranges);
        }
        break;
      default:
        jj_la1[91] = jj_gen;
        ;
      }
      jj_consume_token(SEPARATOR);
                        doSentence(ranges,sentenceToken,getCurrentEnvironment(),true);
    } catch (ParseException ex) {
                getCurrentEnvironment().enableSafeMode();
                writeError(ex);
                Token t;
                do
                {
                         t=getNextToken();
                }while(t.kind!=SEPARATOR && t.kind!=EOF);
    }
  }

  final private void instruction() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case CALL:
      moduleCall();
      break;
    case LET:
      jj_consume_token(LET);
      assignment();
      break;
    case MU:
      initConfiguration();
      break;
    case MARCS:
      marcs();
      break;
    case MDICT:
      mdict();
      break;
    case MINST:
      minst();
      break;
    case MSEQ:
      mseq();
      break;
    case MASYNCH:
      masynch();
      break;
    case MVALID:
      mvalid();
      break;
    case MEMB_IN:
      min();
      break;
    case MEMB_OUT:
      mout();
      break;
    case MULTISET:
      multiSetAsig();
      break;
    case ID:
    case DOLLAR:
    case EMPTY:
    case LSQUARE:
    case LPAR:
    case PLUS:
    case MINUS:
    case DIV:
    case OR:
    case STRING_OBJECT:
      rule();
      break;
    case LBRACE:
      jj_consume_token(LBRACE);
      label_23:
      while (true) {
        sentence();
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case MULTISET:
        case CALL:
        case LET:
        case MU:
        case MEMB_IN:
        case MEMB_OUT:
        case MARCS:
        case MDICT:
        case MINST:
        case MSEQ:
        case MASYNCH:
        case MVALID:
        case ID:
        case DOLLAR:
        case EMPTY:
        case LBRACE:
        case LSQUARE:
        case LPAR:
        case PLUS:
        case MINUS:
        case DIV:
        case OR:
        case STRING_OBJECT:
        case MOUTRES_BINARY:
        case MOUTRES_NATURAL:
        case MOUTRES_SUMMATORIES:
          ;
          break;
        default:
          jj_la1[92] = jj_gen;
          break label_23;
        }
      }
      jj_consume_token(RBRACE);
      break;
    case MOUTRES_BINARY:
      moutres_binary();
      break;
    case MOUTRES_SUMMATORIES:
      moutres_summatories();
      break;
    case MOUTRES_NATURAL:
      moutres_natural();
      break;
    default:
      jj_la1[93] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final private void grammar() throws ParseException {
                 getCurrentEnvironment().disableSafeMode();
    variantDef();
    label_24:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case DEF:
      case LET:
      case ID:
      case DOLLAR:
        ;
        break;
      default:
        jj_la1[94] = jj_gen;
        break label_24;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LET:
      case ID:
      case DOLLAR:
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case LET:
          jj_consume_token(LET);
          break;
        default:
          jj_la1[95] = jj_gen;
          ;
        }
        assignment();
        jj_consume_token(SEPARATOR);
        break;
      case DEF:
        moduleDef();
        break;
      default:
        jj_la1[96] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    jj_consume_token(0);
                   if (getPsystem().getAbstractPsystemFactory()==null)
                        throwSemanticsException("Undefined P system model");
                   doCall("MAIN");
  }

  /** Generated Token Manager. */
  public PlinguaJavaCcParserTokenManager token_source;
  SimpleCharStream jj_input_stream;
  /** Current token. */
  public Token token;
  /** Next token. */
  public Token jj_nt;
  private int jj_ntk;
  private int jj_gen;
  final private int[] jj_la1 = new int[97];
  static private int[] jj_la1_0;
  static private int[] jj_la1_1;
  static private int[] jj_la1_2;
  static {
      jj_la1_init_0();
      jj_la1_init_1();
      jj_la1_init_2();
   }
   private static void jj_la1_init_0() {
      jj_la1_0 = new int[] {0x50000000,0x0,0x0,0x0,0x0,0x0,0x0,0x20000000,0x38000,0x38000,0x0,0x0,0x0,0x0,0x0,0x60000000,0x0,0x60000000,0x60000000,0x6fc07d00,0x0,0x60000000,0x70038000,0x0,0x70038000,0x0,0x0,0x0,0x60000000,0x0,0x10000000,0x0,0x0,0x0,0x0,0x60000000,0x60000000,0x0,0x80000000,0x60080000,0x0,0x80000000,0x0,0x60000000,0x60000000,0x0,0x80000000,0x60080000,0x0,0x60080000,0x0,0x60080000,0x0,0x60000000,0x0,0x0,0x0,0x0,0x0,0x60000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x60000000,0x0,0x60000000,0x60000000,0x0,0x60000000,0x0,0x60000000,0x0,0x60080000,0x200000,0x0,0x0,0x60000000,0x0,0x0,0x0,0x0,0x0,0x6fc07d00,0x6fc07d00,0x60000a00,0x800,0x60000a00,};
   }
   private static void jj_la1_init_1() {
      jj_la1_1 = new int[] {0x0,0x10000,0x200,0x80,0x30000,0x30000,0x18,0x1018,0x0,0x0,0x200000,0x1c0000,0x1c0000,0x30000,0x30000,0x0,0x80,0x40000000,0x0,0xe00b14a0,0x200,0x0,0x31018,0x200,0x31018,0x1000,0x40000,0x30000,0x40000088,0x200,0x0,0x200,0x20080000,0x20080000,0x30000,0x40000020,0x40000020,0x200b0400,0x0,0x40000020,0x200b0400,0x0,0x200b0400,0x40000020,0x40000020,0x200b0400,0x0,0x40000000,0x200,0x40000000,0x200,0x40000020,0x200,0x40000020,0x200,0x10400000,0x200,0x10400000,0x200,0x40000088,0x10400000,0x200,0x1000,0x10400000,0x200,0x1000,0x10400000,0x200,0x1000,0x10400000,0x200,0x1000,0x10400000,0x600b0488,0x1000,0x40000020,0x40000020,0x3,0x40000020,0x200b0400,0x40000020,0x200b0400,0x40000020,0x0,0x801,0x8000,0x0,0x2800000,0x2800000,0xa800000,0x200,0x4000,0xe00b14a0,0xe00b14a0,0x0,0x0,0x0,};
   }
   private static void jj_la1_init_2() {
      jj_la1_2 = new int[] {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x3,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x3,0x3,0x0,0x0,0x0,};
   }

  /** Constructor with InputStream. */
  public PlinguaJavaCcParser(java.io.InputStream stream) {
     this(stream, null);
  }
  /** Constructor with InputStream and supplied encoding */
  public PlinguaJavaCcParser(java.io.InputStream stream, String encoding) {
    try { jj_input_stream = new SimpleCharStream(stream, encoding, 1, 1); } catch(java.io.UnsupportedEncodingException e) { throw new RuntimeException(e); }
    token_source = new PlinguaJavaCcParserTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 97; i++) jj_la1[i] = -1;
  }

  /** Reinitialise. */
  public void ReInit(java.io.InputStream stream) {
     ReInit(stream, null);
  }
  /** Reinitialise. */
  public void ReInit(java.io.InputStream stream, String encoding) {
    try { jj_input_stream.ReInit(stream, encoding, 1, 1); } catch(java.io.UnsupportedEncodingException e) { throw new RuntimeException(e); }
    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 97; i++) jj_la1[i] = -1;
  }

  /** Constructor. */
  public PlinguaJavaCcParser(java.io.Reader stream) {
    jj_input_stream = new SimpleCharStream(stream, 1, 1);
    token_source = new PlinguaJavaCcParserTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 97; i++) jj_la1[i] = -1;
  }

  /** Reinitialise. */
  public void ReInit(java.io.Reader stream) {
    jj_input_stream.ReInit(stream, 1, 1);
    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 97; i++) jj_la1[i] = -1;
  }

  /** Constructor with generated Token Manager. */
  public PlinguaJavaCcParser(PlinguaJavaCcParserTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 97; i++) jj_la1[i] = -1;
  }

  /** Reinitialise. */
  public void ReInit(PlinguaJavaCcParserTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 97; i++) jj_la1[i] = -1;
  }

  private Token jj_consume_token(int kind) throws ParseException {
    Token oldToken;
    if ((oldToken = token).next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    if (token.kind == kind) {
      jj_gen++;
      return token;
    }
    token = oldToken;
    jj_kind = kind;
    throw generateParseException();
  }


/** Get the next Token. */
  final public Token getNextToken() {
    if (token.next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    jj_gen++;
    return token;
  }

/** Get the specific Token. */
  final public Token getToken(int index) {
    Token t = token;
    for (int i = 0; i < index; i++) {
      if (t.next != null) t = t.next;
      else t = t.next = token_source.getNextToken();
    }
    return t;
  }

  private int jj_ntk() {
    if ((jj_nt=token.next) == null)
      return (jj_ntk = (token.next=token_source.getNextToken()).kind);
    else
      return (jj_ntk = jj_nt.kind);
  }

  private java.util.List<int[]> jj_expentries = new java.util.ArrayList<int[]>();
  private int[] jj_expentry;
  private int jj_kind = -1;

  /** Generate ParseException. */
  public ParseException generateParseException() {
    jj_expentries.clear();
    boolean[] la1tokens = new boolean[66];
    if (jj_kind >= 0) {
      la1tokens[jj_kind] = true;
      jj_kind = -1;
    }
    for (int i = 0; i < 97; i++) {
      if (jj_la1[i] == jj_gen) {
        for (int j = 0; j < 32; j++) {
          if ((jj_la1_0[i] & (1<<j)) != 0) {
            la1tokens[j] = true;
          }
          if ((jj_la1_1[i] & (1<<j)) != 0) {
            la1tokens[32+j] = true;
          }
          if ((jj_la1_2[i] & (1<<j)) != 0) {
            la1tokens[64+j] = true;
          }
        }
      }
    }
    for (int i = 0; i < 66; i++) {
      if (la1tokens[i]) {
        jj_expentry = new int[1];
        jj_expentry[0] = i;
        jj_expentries.add(jj_expentry);
      }
    }
    int[][] exptokseq = new int[jj_expentries.size()][];
    for (int i = 0; i < jj_expentries.size(); i++) {
      exptokseq[i] = jj_expentries.get(i);
    }
    return new ParseException(token, exptokseq, tokenImage);
  }

  /** Enable tracing. */
  final public void enable_tracing() {
  }

  /** Disable tracing. */
  final public void disable_tracing() {
  }

}
