/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.util.Comparator;
import org.hsqldb.Expression;
import org.hsqldb.ExpressionColumn;
import org.hsqldb.HsqlException;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.NumberSequence;
import org.hsqldb.ParserDQL;
import org.hsqldb.QueryExpression;
import org.hsqldb.RangeVariable;
import org.hsqldb.Routine;
import org.hsqldb.Session;
import org.hsqldb.SqlInvariants;
import org.hsqldb.Statement;
import org.hsqldb.SubQuery;
import org.hsqldb.Table;
import org.hsqldb.error.Error;
import org.hsqldb.lib.ArraySort;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.HashSet;
import org.hsqldb.lib.OrderedHashSet;
import org.hsqldb.result.Result;
import org.hsqldb.result.ResultMetaData;
import org.hsqldb.store.ValuePool;

public abstract class StatementDMQL
extends Statement {
    public static final String PCOL_PREFIX = "@p";
    static final String RETURN_COLUMN_NAME = "@p0";
    Table targetTable;
    Table baseTable;
    int[] baseColumnMap;
    RangeVariable[] targetRangeVariables = RangeVariable.emptyArray;
    Table sourceTable;
    Expression condition;
    boolean restartIdentity;
    int[] insertColumnMap = ValuePool.emptyIntArray;
    int[] updateColumnMap = ValuePool.emptyIntArray;
    int[] baseUpdateColumnMap = ValuePool.emptyIntArray;
    Expression[] updateExpressions = Expression.emptyArray;
    Expression[][] multiColumnValues;
    Expression insertExpression;
    boolean[] insertCheckColumns;
    boolean[] updateCheckColumns;
    QueryExpression queryExpression;
    ExpressionColumn[] parameters;
    int[] generatedIndexes;
    ResultMetaData generatedResultMetaData;
    ResultMetaData parameterMetaData;
    SubQuery[] subqueries = SubQuery.emptySubqueryArray;
    int rangeIteratorCount;
    NumberSequence[] sequences;
    Routine[] routines;
    RangeVariable[] rangeVariables;

    StatementDMQL(int n, int n2, HsqlNameManager.HsqlName hsqlName) {
        super(n, n2);
        this.schemaName = hsqlName;
        this.isTransactionStatement = true;
    }

    void setBaseIndexColumnMap() {
        if (this.targetTable != this.baseTable) {
            this.baseColumnMap = this.targetTable.getBaseTableColumnMap();
        }
    }

    @Override
    public Result execute(Session session) {
        Result result;
        if (this.targetTable != null && session.isReadOnly() && !this.targetTable.isTemp()) {
            HsqlException hsqlException = Error.error(3706);
            return Result.newErrorResult(hsqlException);
        }
        if (this.isExplain) {
            return this.getExplainResult(session);
        }
        try {
            if (this.subqueries.length > 0) {
                this.materializeSubQueries(session);
            }
            result = this.getResult(session);
        }
        catch (Throwable throwable) {
            result = Result.newErrorResult(throwable, null);
            result.getException().setStatementType(this.group, this.type);
        }
        session.sessionContext.clearStructures(this);
        return result;
    }

    private Result getExplainResult(Session session) {
        HsqlNameManager.HsqlName hsqlName;
        int n;
        Result result = Result.newSingleColumnStringResult("OPERATION", this.describe(session));
        OrderedHashSet orderedHashSet = this.getReferences();
        result.navigator.add(new Object[]{"Object References"});
        for (n = 0; n < orderedHashSet.size(); ++n) {
            hsqlName = (HsqlNameManager.HsqlName)orderedHashSet.get(n);
            result.navigator.add(new Object[]{hsqlName.getSchemaQualifiedStatementName()});
        }
        result.navigator.add(new Object[]{"Read Locks"});
        for (n = 0; n < this.readTableNames.length; ++n) {
            hsqlName = this.readTableNames[n];
            result.navigator.add(new Object[]{hsqlName.getSchemaQualifiedStatementName()});
        }
        result.navigator.add(new Object[]{"WriteLocks"});
        for (n = 0; n < this.writeTableNames.length; ++n) {
            hsqlName = this.writeTableNames[n];
            result.navigator.add(new Object[]{hsqlName.getSchemaQualifiedStatementName()});
        }
        return result;
    }

    abstract Result getResult(Session var1);

    abstract void collectTableNamesForRead(OrderedHashSet var1);

    abstract void collectTableNamesForWrite(OrderedHashSet var1);

    Object[] getGeneratedColumns(Object[] objectArray) {
        if (this.generatedIndexes == null) {
            return null;
        }
        Object[] objectArray2 = new Object[this.generatedIndexes.length];
        for (int i = 0; i < this.generatedIndexes.length; ++i) {
            objectArray2[i] = objectArray[this.generatedIndexes[i]];
        }
        return objectArray2;
    }

    @Override
    public boolean hasGeneratedColumns() {
        return this.generatedIndexes != null;
    }

    @Override
    public ResultMetaData generatedResultMetaData() {
        return this.generatedResultMetaData;
    }

    boolean[] getInsertOrUpdateColumnCheckList() {
        switch (this.type) {
            case 50: {
                return this.insertCheckColumns;
            }
            case 82: {
                return this.updateCheckColumns;
            }
            case 128: {
                boolean[] blArray = (boolean[])ArrayUtil.duplicateArray(this.insertCheckColumns);
                ArrayUtil.orBooleanArray(this.updateCheckColumns, blArray);
                return blArray;
            }
        }
        return null;
    }

    private void setParameters() {
        for (int i = 0; i < this.parameters.length; ++i) {
            this.parameters[i].parameterIndex = i;
        }
    }

    void materializeSubQueries(Session session) {
        HashSet hashSet = new HashSet();
        for (int i = 0; i < this.subqueries.length; ++i) {
            SubQuery subQuery = this.subqueries[i];
            if (!hashSet.add(subQuery) || subQuery.isCorrelated()) continue;
            subQuery.materialise(session);
        }
    }

    SubQuery[] getSubqueries(Session session) {
        int n;
        OrderedHashSet orderedHashSet = null;
        for (n = 0; n < this.targetRangeVariables.length; ++n) {
            if (this.targetRangeVariables[n] == null) continue;
            OrderedHashSet orderedHashSet2 = this.targetRangeVariables[n].getSubqueries();
            orderedHashSet = OrderedHashSet.addAll(orderedHashSet, orderedHashSet2);
        }
        for (n = 0; n < this.updateExpressions.length; ++n) {
            orderedHashSet = this.updateExpressions[n].collectAllSubqueries(orderedHashSet);
        }
        if (this.insertExpression != null) {
            orderedHashSet = this.insertExpression.collectAllSubqueries(orderedHashSet);
        }
        if (this.condition != null) {
            orderedHashSet = this.condition.collectAllSubqueries(orderedHashSet);
        }
        if (this.queryExpression != null) {
            OrderedHashSet orderedHashSet3 = this.queryExpression.getSubqueries();
            orderedHashSet = OrderedHashSet.addAll(orderedHashSet, orderedHashSet3);
        }
        if (orderedHashSet == null || orderedHashSet.size() == 0) {
            return SubQuery.emptySubqueryArray;
        }
        Object[] objectArray = new SubQuery[orderedHashSet.size()];
        orderedHashSet.toArray(objectArray);
        ArraySort.sort(objectArray, 0, objectArray.length, (Comparator)objectArray[0]);
        for (int i = 0; i < objectArray.length; ++i) {
            ((SubQuery)objectArray[i]).prepareTable(session);
        }
        return objectArray;
    }

    void setDatabseObjects(Session session, ParserDQL.CompileContext compileContext) {
        this.parameters = compileContext.getParameters();
        this.setParameters();
        this.setParameterMetaData();
        this.subqueries = this.getSubqueries(session);
        this.rangeIteratorCount = compileContext.getRangeVarCount();
        this.rangeVariables = compileContext.getRangeVariables();
        this.sequences = compileContext.getSequences();
        this.routines = compileContext.getRoutines();
        OrderedHashSet orderedHashSet = new OrderedHashSet();
        this.collectTableNamesForWrite(orderedHashSet);
        if (orderedHashSet.size() > 0) {
            this.writeTableNames = new HsqlNameManager.HsqlName[orderedHashSet.size()];
            orderedHashSet.toArray(this.writeTableNames);
            orderedHashSet.clear();
        }
        this.collectTableNamesForRead(orderedHashSet);
        orderedHashSet.removeAll(this.writeTableNames);
        if (orderedHashSet.size() > 0) {
            this.readTableNames = new HsqlNameManager.HsqlName[orderedHashSet.size()];
            orderedHashSet.toArray(this.readTableNames);
        }
        this.references = compileContext.getSchemaObjectNames();
        if (this.targetTable != null) {
            this.references.add(this.targetTable.getName());
        }
    }

    void checkAccessRights(Session session) {
        int n;
        if (this.targetTable != null && !this.targetTable.isTemp()) {
            if (this.targetTable.getOwner().isSystem() && !session.getUser().isSystem()) {
                throw Error.error(5501, this.targetTable.getName().name);
            }
            if (!session.isProcessingScript) {
                this.targetTable.checkDataReadOnly();
            }
            session.checkReadWrite();
        }
        if (session.isAdmin()) {
            return;
        }
        for (n = 0; n < this.sequences.length; ++n) {
            session.getGrantee().checkAccess(this.sequences[n]);
        }
        for (n = 0; n < this.routines.length; ++n) {
            if (this.routines[n].isLibraryRoutine()) continue;
            session.getGrantee().checkAccess(this.routines[n]);
        }
        for (n = 0; n < this.rangeVariables.length; ++n) {
            RangeVariable rangeVariable = this.rangeVariables[n];
            if (rangeVariable.rangeTable.getSchemaName() == SqlInvariants.SYSTEM_SCHEMA_HSQLNAME) continue;
            session.getGrantee().checkSelect(rangeVariable.rangeTable, rangeVariable.usedColumns);
        }
        switch (this.type) {
            case 7: {
                break;
            }
            case 50: {
                session.getGrantee().checkInsert(this.targetTable, this.insertCheckColumns);
                break;
            }
            case 85: {
                break;
            }
            case 19: {
                session.getGrantee().checkDelete(this.targetTable);
                break;
            }
            case 82: {
                session.getGrantee().checkUpdate(this.targetTable, this.updateCheckColumns);
                break;
            }
            case 128: {
                session.getGrantee().checkInsert(this.targetTable, this.insertCheckColumns);
                session.getGrantee().checkUpdate(this.targetTable, this.updateCheckColumns);
            }
        }
    }

    Result getWriteAccessResult(Session session) {
        try {
            if (this.targetTable != null && !this.targetTable.isTemp()) {
                session.checkReadWrite();
            }
        }
        catch (HsqlException hsqlException) {
            return Result.newErrorResult(hsqlException);
        }
        return null;
    }

    @Override
    public ResultMetaData getResultMetaData() {
        switch (this.type) {
            case 19: 
            case 50: 
            case 82: 
            case 128: {
                return ResultMetaData.emptyResultMetaData;
            }
        }
        throw Error.runtimeError(201, "StatementDMQL");
    }

    @Override
    public ResultMetaData getParametersMetaData() {
        return this.parameterMetaData;
    }

    void setParameterMetaData() {
        int n = 0;
        if (this.parameters.length == 0) {
            this.parameterMetaData = ResultMetaData.emptyParamMetaData;
            return;
        }
        this.parameterMetaData = ResultMetaData.newParameterMetaData(this.parameters.length);
        for (int i = 0; i < this.parameters.length; ++i) {
            int n2 = i + n;
            this.parameterMetaData.columnLabels[n2] = PCOL_PREFIX + (i + 1);
            this.parameterMetaData.columnTypes[n2] = this.parameters[i].dataType;
            byte by = 1;
            if (this.parameters[i].column != null && this.parameters[i].column.getParameterMode() != 0) {
                by = this.parameters[i].column.getParameterMode();
            }
            this.parameterMetaData.paramModes[n2] = by;
            this.parameterMetaData.paramNullable[n2] = this.parameters[i].column == null ? (byte)1 : this.parameters[i].column.getNullability();
        }
    }

    @Override
    public String describe(Session session) {
        try {
            return this.describeImpl(session);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return throwable.toString();
        }
    }

    String describeImpl(Session session) throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        switch (this.type) {
            case 85: {
                stringBuffer.append(this.queryExpression.describe(session, 0));
                this.appendParms(stringBuffer).append('\n');
                this.appendSubqueries(session, stringBuffer, 2);
                return stringBuffer.toString();
            }
            case 50: {
                if (this.queryExpression == null) {
                    stringBuffer.append("INSERT VALUES");
                    stringBuffer.append('[').append('\n');
                    this.appendMultiColumns(stringBuffer, this.insertColumnMap).append('\n');
                    this.appendTable(stringBuffer).append('\n');
                    this.appendParms(stringBuffer).append('\n');
                    this.appendSubqueries(session, stringBuffer, 2).append(']');
                    return stringBuffer.toString();
                }
                stringBuffer.append("INSERT SELECT");
                stringBuffer.append('[').append('\n');
                this.appendColumns(stringBuffer, this.insertColumnMap).append('\n');
                this.appendTable(stringBuffer).append('\n');
                stringBuffer.append(this.queryExpression.describe(session, n)).append('\n');
                this.appendParms(stringBuffer).append('\n');
                this.appendSubqueries(session, stringBuffer, 2).append(']');
                return stringBuffer.toString();
            }
            case 82: {
                stringBuffer.append("UPDATE");
                stringBuffer.append('[').append('\n');
                this.appendColumns(stringBuffer, this.updateColumnMap).append('\n');
                this.appendTable(stringBuffer).append('\n');
                this.appendCondition(session, stringBuffer);
                for (int i = 0; i < this.targetRangeVariables.length; ++i) {
                    stringBuffer.append(this.targetRangeVariables[i].describe(session, n)).append('\n');
                }
                this.appendParms(stringBuffer).append('\n');
                this.appendSubqueries(session, stringBuffer, 2).append(']');
                return stringBuffer.toString();
            }
            case 19: {
                stringBuffer.append("DELETE");
                stringBuffer.append('[').append('\n');
                this.appendTable(stringBuffer).append('\n');
                this.appendCondition(session, stringBuffer);
                for (int i = 0; i < this.targetRangeVariables.length; ++i) {
                    stringBuffer.append(this.targetRangeVariables[i].describe(session, n)).append('\n');
                }
                this.appendParms(stringBuffer).append('\n');
                this.appendSubqueries(session, stringBuffer, 2).append(']');
                return stringBuffer.toString();
            }
            case 7: {
                stringBuffer.append("CALL");
                stringBuffer.append('[').append(']');
                return stringBuffer.toString();
            }
            case 128: {
                stringBuffer.append("MERGE");
                stringBuffer.append('[').append('\n');
                this.appendMultiColumns(stringBuffer, this.insertColumnMap).append('\n');
                this.appendColumns(stringBuffer, this.updateColumnMap).append('\n');
                this.appendTable(stringBuffer).append('\n');
                this.appendCondition(session, stringBuffer);
                for (int i = 0; i < this.targetRangeVariables.length; ++i) {
                    stringBuffer.append(this.targetRangeVariables[i].describe(session, n)).append('\n');
                }
                this.appendParms(stringBuffer).append('\n');
                this.appendSubqueries(session, stringBuffer, 2).append(']');
                return stringBuffer.toString();
            }
        }
        return "UNKNOWN";
    }

    private StringBuffer appendSubqueries(Session session, StringBuffer stringBuffer, int n) {
        stringBuffer.append("SUBQUERIES[");
        for (int i = 0; i < this.subqueries.length; ++i) {
            stringBuffer.append("\n[level=").append(this.subqueries[i].level).append('\n');
            if (this.subqueries[i].queryExpression != null) {
                stringBuffer.append(this.subqueries[i].queryExpression.describe(session, n));
            }
            stringBuffer.append("]");
        }
        stringBuffer.append(']');
        return stringBuffer;
    }

    private StringBuffer appendTable(StringBuffer stringBuffer) {
        stringBuffer.append("TABLE[").append(this.targetTable.getName().name).append(']');
        return stringBuffer;
    }

    private StringBuffer appendSourceTable(StringBuffer stringBuffer) {
        stringBuffer.append("SOURCE TABLE[").append(this.sourceTable.getName().name).append(']');
        return stringBuffer;
    }

    private StringBuffer appendColumns(StringBuffer stringBuffer, int[] nArray) {
        int n;
        if (nArray == null || this.updateExpressions.length == 0) {
            return stringBuffer;
        }
        stringBuffer.append("COLUMNS=[");
        for (n = 0; n < nArray.length; ++n) {
            stringBuffer.append('\n').append(nArray[n]).append(':').append(' ').append(this.targetTable.getColumn(nArray[n]).getNameString());
        }
        for (n = 0; n < this.updateExpressions.length; ++n) {
            stringBuffer.append('[').append(this.updateExpressions[n]).append(']');
        }
        stringBuffer.append(']');
        return stringBuffer;
    }

    private StringBuffer appendMultiColumns(StringBuffer stringBuffer, int[] nArray) {
        if (nArray == null || this.multiColumnValues == null) {
            return stringBuffer;
        }
        stringBuffer.append("COLUMNS=[");
        for (int i = 0; i < this.multiColumnValues.length; ++i) {
            for (int j = 0; j < nArray.length; ++j) {
                stringBuffer.append('\n').append(nArray[j]).append(':').append(' ').append(this.targetTable.getColumn((int)nArray[j]).getName().name).append('[').append(this.multiColumnValues[i][j]).append(']');
            }
        }
        stringBuffer.append(']');
        return stringBuffer;
    }

    private StringBuffer appendParms(StringBuffer stringBuffer) {
        stringBuffer.append("PARAMETERS=[");
        for (int i = 0; i < this.parameters.length; ++i) {
            stringBuffer.append('\n').append('@').append(i).append('[').append(this.parameters[i].describe(null, 0)).append(']');
        }
        stringBuffer.append(']');
        return stringBuffer;
    }

    private StringBuffer appendCondition(Session session, StringBuffer stringBuffer) {
        return this.condition == null ? stringBuffer.append("CONDITION[]\n") : stringBuffer.append("CONDITION[").append(this.condition.describe(session, 0)).append("]\n");
    }

    @Override
    public void resolve(Session session) {
    }

    @Override
    public RangeVariable[] getRangeVariables() {
        return this.rangeVariables;
    }

    @Override
    public final boolean isCatalogChange() {
        return false;
    }
}

