/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.transformers;

import java.lang.annotation.Annotation;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;
import org.eclipse.persistence.internal.jpa.metadata.columns.ColumnMetadata;
import org.eclipse.persistence.internal.jpa.metadata.transformers.MetadataHelper;
import org.eclipse.persistence.internal.jpa.metadata.transformers.ReadTransformerMetadata;
import org.eclipse.persistence.mappings.TransformationMapping;

public class WriteTransformerMetadata
extends ReadTransformerMetadata {
    private ColumnMetadata m_column;

    public WriteTransformerMetadata() {
        super("<write-transformer>");
    }

    public WriteTransformerMetadata(Annotation writeTransformer, MetadataAccessibleObject accessibleObject) {
        super(writeTransformer, accessibleObject);
        this.m_column = new ColumnMetadata((Annotation)MetadataHelper.invokeMethod("column", writeTransformer), accessibleObject);
    }

    public ColumnMetadata getColumn() {
        return this.m_column;
    }

    public boolean hasFieldName() {
        return this.m_column != null && this.m_column.getName() != null && this.m_column.getName().length() > 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void process(TransformationMapping mapping, String annotatedElementName) {
        if (!this.hasFieldName()) throw ValidationException.writeTransformerHasNoColumnName(annotatedElementName);
        if (this.getMethod() == null || this.getMethod().equals("")) {
            if (this.getTransformerClass().equals(Void.TYPE)) {
                throw ValidationException.writeTransformerHasNeitherClassNorMethod(annotatedElementName, this.m_column.getName());
            }
            if (!MetadataHelper.classImplementsInterface(this.getTransformerClass(), "org.eclipse.persistence.mappings.transformers.FieldTransformer")) throw ValidationException.writeTransformerClassDoesntImplementFieldTransformer(annotatedElementName, this.m_column.getName());
            mapping.addFieldTransformerClassName(this.m_column.getDatabaseField(), this.getTransformerClass().getName());
            return;
        } else {
            if (!this.getTransformerClass().equals(Void.TYPE)) throw ValidationException.writeTransformerHasBothClassAndMethod(annotatedElementName, this.m_column.getName());
            mapping.addFieldTransformation(this.m_column.getDatabaseField(), this.getMethod());
        }
    }

    public void setColumn(ColumnMetadata column) {
        this.m_column = column;
    }

    public void setFieldName(String fieldName) {
        if (this.m_column == null) {
            this.m_column = new ColumnMetadata();
        }
        this.m_column.setName(fieldName);
    }
}

