/*
 * Decompiled with CFR 0.152.
 */
package ecoSim.gui.menu.block;

import ecoSim.DAOFacade;
import ecoSim.actions.EcoSimChangeAlgorithmAction;
import ecoSim.actions.EcoSimCyclesAction;
import ecoSim.actions.EcoSimInitModelAction;
import ecoSim.actions.EcoSimResetSimulationAction;
import ecoSim.actions.EcoSimSimulateAction;
import ecoSim.actions.EcoSimSimulateStepAction;
import ecoSim.actions.EcoSimSimulationsByCycleAction;
import ecoSim.gui.AbstractEcoSimGUI;
import ecoSim.gui.menu.EcoSimMenu;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Iterator;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import org.gcn.plinguacore.util.PlinguaCoreException;

public class EcoSimSimulationBlock
extends EcoSimMenu {
    public EcoSimSimulationBlock(AbstractEcoSimGUI gui) {
        super("EcoSimSimulationBlock", 2, gui);
        this.addMenuItem("0", "Simulate!", EcoSimSimulateAction.getInstance(), KeyStroke.getKeyStroke(76, 2));
        this.addMenuSeparator("1");
        this.addMenuItem("2", "Options");
        this.addMenuItem("2,0", "Number of cycles", EcoSimCyclesAction.getInstance());
        this.addMenuItem("2,1", "Number of simulations (by cycle)", EcoSimSimulationsByCycleAction.getInstance());
        if (!gui.getData().isUserMode()) {
            this.generateSimulatorsOptions(gui);
            this.addMenuSeparator("3");
            this.addMenuItem("4", "Debug");
            this.addMenuItem("4,0", "Step", EcoSimSimulateStepAction.getInstance(), KeyStroke.getKeyStroke(44, 2));
            this.addMenuItem("4,1", "Reset", EcoSimResetSimulationAction.getInstance(), KeyStroke.getKeyStroke(45, 2));
            this.addMenuSeparator("4,2");
            this.addMenuItem("4,3", "Init Model", EcoSimInitModelAction.getInstance(), KeyStroke.getKeyStroke(73, 2));
        }
    }

    private void generateSimulatorsOptions(AbstractEcoSimGUI gui) {
        this.addMenuSeparator("2,2");
        this.addMenuItem("2,3", "Simulation Algorithm");
        try {
            File f = gui.getData().getPlinguaFile();
            if (f != null && f.exists() && !f.isDirectory()) {
                this.addAvailableSimulatorsItems(gui, f);
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (PlinguaCoreException e) {
            e.printStackTrace();
        }
    }

    private void addAvailableSimulatorsItems(AbstractEcoSimGUI gui, File f) throws FileNotFoundException, IOException, PlinguaCoreException {
        Iterator<String> sims = DAOFacade.getAvailableSimulatorsForModel(f);
        if (sims != null) {
            String simulator;
            int i = 0;
            int n = 0;
            while (sims.hasNext()) {
                simulator = sims.next();
                ++i;
            }
            n = i;
            sims = DAOFacade.getAvailableSimulatorsForModel(f);
            String currentSim = gui.getData().getSimulationAlgorithm();
            i = 0;
            String prefix = "2,3,";
            while (sims.hasNext()) {
                simulator = sims.next();
                boolean selected = currentSim != null && !currentSim.equals("none") ? currentSim.equals(simulator) : i == n - 1;
                this.addMenuItem(String.valueOf(prefix) + i, simulator, EcoSimChangeAlgorithmAction.getInstance(simulator), 1, selected);
                if (selected) {
                    gui.getData().setSimulationAlgorithm(simulator);
                }
                ++i;
            }
        } else {
            JOptionPane.showMessageDialog(null, "Available simulators for the model indicated in the loaded P-Lingua file could not be found.\nPlease check the contents of the file.", "Available simulators not found!", 1);
        }
    }
}

