/*
 * Decompiled with CFR 0.152.
 */
package ecoSim.gui;

import ecoSim.factory.AbstractEcoSimFactory;
import ecoSim.gui.AbstractEcoSimGUI;
import ecoSim.gui.MySwingWorker;
import java.awt.Cursor;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.gcn.plinguacore.simulator.cellLike.probabilistic.ProbabilisticPsystemFactory;
import org.gcn.plinguacore.util.psystem.Psystem;
import org.gcn.plinguacore.util.psystem.cellLike.CellLikePsystem;

public class ParserSwingWorker
extends MySwingWorker<Void, Void> {
    private static final int verbosity = 5;
    private AbstractEcoSimGUI gui;

    public ParserSwingWorker(AbstractEcoSimGUI gui) {
        this.gui = gui;
    }

    private void getInfo() {
        Psystem ps = this.gui.getData().getSimulator().getPsystem();
        System.out.println("Alphabet: " + ps.getAlphabet().size());
        System.out.println("Membranes: " + ps.getMembraneStructure().getAllMembranes().size());
        System.out.println("Rules: " + ps.getRules().size());
        Map map = ProbabilisticPsystemFactory.getRulesByActivationSet((CellLikePsystem)((CellLikePsystem)ps));
        System.out.println("Sets of rules: " + map.size());
        long count = 0L;
        int max = 0;
        int min = Integer.MAX_VALUE;
        Iterator it = map.values().iterator();
        while (it.hasNext()) {
            int x = ((List)it.next()).size();
            if (x > max) {
                max = x;
            }
            if (x < min) {
                min = x;
            }
            count += (long)x;
        }
        System.out.println("Average: " + count / (long)map.size());
        System.out.println("Min: " + min);
        System.out.println("Max: " + max);
    }

    @Override
    protected Void doInBackground() throws Exception {
        this.gui.getFrame().setCursor(Cursor.getPredefinedCursor(3));
        this.gui.getData().beginSimulationState();
        this.gui.getData().readPLinguaFile(this.gui.getPrintStreams().get("Errors"), this.gui.getPrintStreams().get("Warnings"), this.gui.getPrintStreams().get("Information"), AbstractEcoSimFactory.getFactory(this.gui.getData().getFactoryName()).createParametersStrategy(), 5, null, this.gui.getData().getSimulationAlgorithm());
        this.gui.getFrame().setCursor(null);
        this.gui.getData().endSimulationState();
        return null;
    }

    @Override
    protected void done() {
        this.gui.getFrame().setCursor(null);
        this.gui.getData().endSimulationState();
        super.done();
    }
}

