/*
 * Decompiled with CFR 0.152.
 */
package ecoSim.gui;

import ecoSim.data.DataBlockTableModel;
import ecoSim.gui.AbstractEcoSimGUI;
import ecoSim.gui.AbstractEcoSimView;
import ecoSim.gui.menu.block.EcoSimEditMenuBlock;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.table.JTableHeader;

public class EcoSimViewTable
extends AbstractEcoSimView
implements FocusListener {
    private JTable table = null;
    private DataBlockTableModel data;
    private JPopupMenu editMenu;

    public EcoSimViewTable(DataBlockTableModel data, boolean border, AbstractEcoSimGUI gui) {
        super(data.getName(), border, gui);
        this.data = data;
        this.setText(data.getText());
        data.setView(this);
        EcoSimEditMenuBlock editMenuBlock = new EcoSimEditMenuBlock(gui);
        editMenuBlock.setType(1);
        this.editMenu = (JPopupMenu)editMenuBlock.getView();
    }

    @Override
    public JScrollPane createSpecificView() {
        JScrollPane scrollPane = new JScrollPane();
        this.table = new JTable(this.data){
            private static final long serialVersionUID = 3666948305988285243L;

            @Override
            protected boolean processKeyBinding(KeyStroke ks, KeyEvent e, int condition, boolean pressed) {
                if (e.getKeyCode() == 127 && e.getModifiers() == 0 || e.getKeyCode() == 88 && e.getModifiers() == 2 || e.getKeyCode() == 67 && e.getModifiers() == 2 || e.getKeyCode() == 86 && e.getModifiers() == 2 || e.getKeyCode() == 65 && e.getModifiers() == 2) {
                    return false;
                }
                return super.processKeyBinding(ks, e, condition, pressed);
            }

            @Override
            public String getToolTipText(MouseEvent e) {
                Point p = e.getPoint();
                int rowIndex = this.rowAtPoint(p);
                int colIndex = this.columnAtPoint(p);
                String cellName = EcoSimViewTable.this.data.getCellName(this.convertRowIndexToModel(rowIndex), this.convertColumnIndexToModel(colIndex));
                String tip = null;
                if (this.getValueAt(rowIndex, colIndex) != null) {
                    tip = this.getValueAt(rowIndex, colIndex).toString();
                }
                if (cellName != null && cellName != "") {
                    tip = String.valueOf(cellName) + " = " + tip;
                }
                return tip;
            }

            @Override
            protected JTableHeader createDefaultTableHeader() {
                return new JTableHeader(this.columnModel){
                    private static final long serialVersionUID = -1662682583418418086L;

                    @Override
                    public String getToolTipText(MouseEvent e) {
                        Point p = e.getPoint();
                        int index = this.columnModel.getColumnIndexAtX(p.x);
                        int realIndex = this.columnModel.getColumn(index).getModelIndex();
                        return EcoSimViewTable.this.data.getColumnDescription(realIndex);
                    }
                };
            }
        };
        this.table.setCellSelectionEnabled(true);
        this.table.setName(this.getName());
        this.table.addFocusListener(this);
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                int nModifier = e.getModifiers();
                if ((nModifier & 8) != 0 || (nModifier & 4) != 0) {
                    JTable table = (JTable)e.getSource();
                    EcoSimViewTable.this.editMenu.show(table, e.getX(), e.getY());
                }
            }
        });
        scrollPane.setViewportView(this.table);
        scrollPane.setName(this.getName());
        scrollPane.setPreferredSize(new Dimension(385, 193));
        return scrollPane;
    }

    @Override
    public void focusGained(FocusEvent arg0) {
        this.getGUI().setFocusComponent(arg0.getComponent());
    }

    @Override
    public void focusLost(FocusEvent arg0) {
    }

    public JTable getJTable() {
        return this.table;
    }
}

