/*
 * Decompiled with CFR 0.152.
 */
package ecoSim.gui;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;

public class CustomRenderer
extends XYLineAndShapeRenderer {
    private static final long serialVersionUID = 2558896005776512667L;
    private float[] dash1 = new float[]{2.0f, 4.0f};
    private Stroke dashed = new BasicStroke(2.0f, 0, 0, 10.0f, this.dash1, 0.0f);
    private Paint[] colors;

    public CustomRenderer() {
        super(true, false);
    }

    public CustomRenderer(Paint[] colors) {
        this.colors = colors;
    }

    @Override
    public Paint getSeriesPaint(int series) {
        return this.colors[series];
    }

    @Override
    public Paint getSeriesOutlinePaint(int series) {
        if (series == 3) {
            return Color.black;
        }
        return super.getSeriesOutlinePaint(series);
    }

    @Override
    public boolean getItemLineVisible(int series, int item) {
        return series != 3;
    }

    @Override
    public boolean getItemShapeVisible(int series, int item) {
        return series == 3;
    }

    @Override
    public Stroke getSeriesStroke(int series) {
        if (series == 1 || series == 3) {
            return super.getSeriesStroke(series);
        }
        return this.dashed;
    }

    @Override
    public Boolean getSeriesVisibleInLegend(int series) {
        if (series != 0) {
            return true;
        }
        return false;
    }

    @Override
    public boolean isSeriesVisibleInLegend(int series) {
        return this.getSeriesVisibleInLegend(series);
    }

    @Override
    public Shape getSeriesShape(int series) {
        return super.getSeriesShape(1);
    }
}

