/*
 * Decompiled with CFR 0.152.
 */
package ecoSim.factory;

import ecoSim.DAOFacade;
import ecoSim.entities.SimulationRegister;
import ecoSim.factory.CustomOutputMapKey;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gcn.plinguacore.simulator.ISimulator;
import org.gcn.plinguacore.util.MultiSet;
import org.gcn.plinguacore.util.psystem.membrane.ChangeableMembrane;
import org.gcn.plinguacore.util.psystem.membrane.Membrane;

public class CustomOutputSingleton {
    private static Map<CustomOutputMapKey, CustomOutputSingleton> outputs = new HashMap<CustomOutputMapKey, CustomOutputSingleton>();
    private List<SimulationRegister> simulationRegisters = null;

    public static void resetOutputs() {
        outputs = new HashMap<CustomOutputMapKey, CustomOutputSingleton>();
    }

    private CustomOutputSingleton(int appId, ISimulator sim, int nsim, int year, int step, int stepsByYear, int simulatedYears) {
        if (nsim == 1 && year == 0 && step == 0) {
            DAOFacade.deleteRegisters(appId);
        }
        ArrayList<SimulationRegister> registers = new ArrayList<SimulationRegister>();
        Collection membranes = sim.getCurrentConfig().getMembraneStructure().getAllMembranes();
        long tiempoInicio = System.currentTimeMillis();
        for (Membrane memb : membranes) {
            String envID = memb.getLabelObj().getEnvironmentID();
            String label = memb.getLabel();
            int membID = 0;
            if (memb instanceof ChangeableMembrane) {
                ChangeableMembrane cl = (ChangeableMembrane)memb;
                membID = cl.getId();
            }
            MultiSet multiset = memb.getMultiSet();
            Set set = multiset.entrySet();
            for (String object : set) {
                long mult = multiset.count((Object)object);
                SimulationRegister reg = new SimulationRegister(appId, membID, envID, label, mult, object, nsim, year, step);
                DAOFacade.insertSimulationRegister(reg);
                registers.add(reg);
            }
        }
        MultiSet multiset = sim.getCurrentConfig().getEnvironment();
        Set set = multiset.entrySet();
        for (String object : set) {
            long mult = multiset.count((Object)object);
            SimulationRegister reg = new SimulationRegister(appId, 0, "Environment", "0", mult, object, nsim, year, step);
            DAOFacade.insertSimulationRegister(reg);
            registers.add(reg);
        }
        this.setSimulationRegisters(registers);
        if (step == stepsByYear && year == simulatedYears) {
            System.out.println("Persisting simulation " + nsim + "...");
            DAOFacade.persistRegisters();
            System.out.println("This single simulation is ready!" + nsim + "!");
        }
    }

    public static synchronized CustomOutputSingleton getOutput(int appId, ISimulator sim, int nsim, int year, int step, int stepsByYear, int simulatedYears) {
        CustomOutputMapKey key = new CustomOutputMapKey(nsim, year, step);
        CustomOutputSingleton output = outputs.get(key);
        if (output == null) {
            output = new CustomOutputSingleton(appId, sim, nsim, year, step, stepsByYear, simulatedYears);
            outputs.put(key, output);
        }
        return output;
    }

    public List<SimulationRegister> getSimulationRegisters() {
        return this.simulationRegisters;
    }

    public void setSimulationRegisters(List<SimulationRegister> simulationRegisters) {
        this.simulationRegisters = simulationRegisters;
    }

    public static void persistAndPrint(int appId) {
        DAOFacade.persistRegisters();
    }

    public static void printRegisters(int appId, int filterStep) {
        DAOFacade.printSummary(filterStep);
    }
}

