/*
 * Decompiled with CFR 0.152.
 */
package ecoSim.factory;

import ecoSim.DAOFacade;
import ecoSim.data.AbstractEcoSimData;
import ecoSim.data.OutputDataBlockTableModel;
import ecoSim.entities.TableColumn;
import ecoSim.entities.TableData;
import ecoSim.factory.CustomBarChart;
import ecoSim.factory.CustomEcoSimData;
import ecoSim.factory.CustomLineChart;
import ecoSim.factory.CustomOutputSingleton;
import ecoSim.factory.CustomPieChart;
import ecoSim.factory.CustomStackedBarChart;
import ecoSim.properties.UnavailablePropertyException;
import java.util.List;
import org.gcn.plinguacore.simulator.ISimulator;

public class CustomOutputDataBlock
extends OutputDataBlockTableModel {
    private TableData data = null;
    public CustomEcoSimData cdata = null;

    public CustomOutputDataBlock(TableData data, AbstractEcoSimData listener) {
        super(data.getTableConfig().getNombre(), listener);
        if (data == null) {
            throw new NullPointerException();
        }
        this.setData(data);
        if (listener instanceof CustomEcoSimData) {
            this.cdata = (CustomEcoSimData)listener;
        }
        this.clear();
    }

    @Override
    public void update(int currentStep, int currentYear, int currentSimulation, ISimulator sim) {
        long tiempoInicio = System.currentTimeMillis();
        CustomOutputSingleton output = null;
        output = CustomOutputSingleton.getOutput(this.getData().getTableConfig().getIdApp(), sim, currentSimulation, currentYear, currentStep, this.getListener().getStepsByCycle(), this.getListener().getSimulatedCycles());
        long totalTiempo = System.currentTimeMillis() - tiempoInicio;
        if (currentStep == this.getListener().getStepsByCycle() && currentYear == this.getListener().getSimulatedCycles() && currentSimulation == this.getListener().getSimulationsByCycle()) {
            this.generateTable();
        } else {
            this.getListener().getSimulatedCycles();
        }
    }

    public void generateTable(int filterStep) {
        String[][] result;
        DAOFacade.printSummary(filterStep);
        DAOFacade.printHSQLDB(filterStep);
        if (this.getData() != null && (result = DAOFacade.getResult(filterStep)) != null) {
            this.setSize(result.length, result[0].length);
            int i = 0;
            while (i < result.length) {
                int j = 0;
                while (j < result[i].length) {
                    this.setValueAt(result[i][j], i, j);
                    ++j;
                }
                ++i;
            }
        }
    }

    public void generateTable() {
        int appId = this.getData().getTableConfig().getIdApp();
        int tableId = this.getData().getTableConfig().getIdTabla();
        if (this.getData() != null) {
            System.out.println("AppId: " + appId + ", tableId: " + tableId);
            String[][] result = DAOFacade.getResults(appId, tableId, this.cdata.getParsedParameters());
            if (result != null && result.length > 0) {
                boolean generateGraphics;
                this.setSize(result.length, result[0].length);
                int i = 0;
                while (i < result.length) {
                    int j = 0;
                    while (j < result[i].length) {
                        this.setValueAt(result[i][j], i, j);
                        ++j;
                    }
                    ++i;
                }
                int categoryIndex = -1;
                int subCategoryIndex = -1;
                int seriesIndex = -1;
                int dataIndex = -1;
                String chartName = this.getData().getTableConfig().getGraphic();
                if (chartName != null && chartName.equals("Default")) {
                    int length = result[0].length;
                    chartName = this.getDefaultName(length);
                }
                boolean bl = generateGraphics = chartName != null && !chartName.equals("") && this.isValidChartName(chartName);
                if (generateGraphics) {
                    if (chartName.equals("PieChart") && result[0].length >= 2) {
                        int i2 = 0;
                        for (TableColumn col : this.getData().getColumns()) {
                            System.out.println(col.getNombreCol());
                            if (col.getGraphicRole().equals("Category")) {
                                categoryIndex = i2;
                            } else if (col.getGraphicRole().equals("Data")) {
                                dataIndex = i2;
                            } else {
                                System.err.println("*** WARNING: Column not assigned to a graphical role: " + col.getNombreCol());
                            }
                            ++i2;
                        }
                        if (categoryIndex >= 0 && dataIndex >= 0) {
                            CustomPieChart graph = null;
                            graph = new CustomPieChart(this.getData().getTableConfig().getNombre(), result, categoryIndex, dataIndex);
                            graph.showGraph();
                        } else {
                            System.err.println("*** WARNING: Some needed graphical role is not present");
                        }
                    } else if ((chartName.equals("LineChart") || chartName.equals("BarChart")) && result[0].length >= 3) {
                        int i3 = 0;
                        for (TableColumn col : this.getData().getColumns()) {
                            System.out.println(col.getNombreCol());
                            if (col.getGraphicRole().equals("Category")) {
                                categoryIndex = i3;
                            } else if (col.getGraphicRole().equals("Series")) {
                                seriesIndex = i3;
                            } else if (col.getGraphicRole().equals("Data")) {
                                dataIndex = i3;
                            } else {
                                System.out.println("Column not assigned to a graphical role: " + col.getNombreCol());
                            }
                            ++i3;
                        }
                        if (categoryIndex != -1 && seriesIndex != -1 && dataIndex != -1) {
                            String domain = "";
                            String range = "";
                            List<TableColumn> columns = this.getData().getColumns();
                            domain = String.valueOf(columns.get(categoryIndex).getNombreCol()) + " / " + columns.get(seriesIndex).getNombreCol();
                            range = columns.get(dataIndex).getNombreCol();
                            if (chartName.equals("LineChart")) {
                                CustomLineChart graph = null;
                                graph = new CustomLineChart(this.getData().getTableConfig().getNombre(), result, domain, range, categoryIndex, seriesIndex, dataIndex);
                                graph.showGraph();
                            } else if (chartName.equals("BarChart")) {
                                CustomBarChart graph = null;
                                graph = new CustomBarChart(this.getData().getTableConfig().getNombre(), result, domain, range, categoryIndex, seriesIndex, dataIndex);
                                graph.showGraph();
                            }
                        } else {
                            System.err.println("*** WARNING: Some needed graphical role is not present");
                        }
                    } else if (chartName.equals("StackedBarChart") && result[0].length >= 4) {
                        int i4 = 0;
                        for (TableColumn col : this.getData().getColumns()) {
                            System.out.println(col.getNombreCol());
                            if (col.getGraphicRole().equals("Category")) {
                                categoryIndex = i4;
                            } else if (col.getGraphicRole().equals("Subcategory")) {
                                subCategoryIndex = i4;
                            } else if (col.getGraphicRole().equals("Series")) {
                                seriesIndex = i4;
                            } else if (col.getGraphicRole().equals("Data")) {
                                dataIndex = i4;
                            } else {
                                System.err.println("*** WARNING: Column not assigned to a graphical role: " + col.getNombreCol());
                            }
                            ++i4;
                        }
                        if (categoryIndex != -1 && subCategoryIndex != -1 && seriesIndex != -1 && dataIndex != -1) {
                            CustomStackedBarChart graph = null;
                            String group = "";
                            String subgroup = "";
                            String part = "";
                            String dataName = "";
                            List<TableColumn> columns = this.getData().getColumns();
                            group = columns.get(categoryIndex).getNombreCol();
                            subgroup = columns.get(subCategoryIndex).getNombreCol().substring(0, 4);
                            part = columns.get(seriesIndex).getNombreCol();
                            dataName = columns.get(dataIndex).getNombreCol();
                            graph = new CustomStackedBarChart(this.getData().getTableConfig().getNombre(), result, group, subgroup, part, dataName, categoryIndex, subCategoryIndex, seriesIndex, dataIndex);
                            graph.showGraph();
                        } else {
                            System.err.println("*** WARNING: Some needed graphical role is not present");
                        }
                    }
                }
            }
        }
    }

    private String getDefaultName(int length) {
        String name = "";
        try {
            name = DAOFacade.getProperty("default-chart-" + length);
        }
        catch (UnavailablePropertyException e) {
            System.err.println("*** WARNING: Unavailable property default-chart-" + length + ". No chart available with length = " + length);
        }
        return name;
    }

    private boolean isValidChartName(String name) {
        boolean valid = false;
        try {
            String property = DAOFacade.getProperty("valid-chart-" + name);
            if (property != null && property.equals("True")) {
                valid = true;
            }
        }
        catch (UnavailablePropertyException e) {
            valid = false;
        }
        return valid;
    }

    @Override
    public void clear() {
        if (this.getData() != null) {
            int nRows = this.getData().getTableConfig().getNrows();
            int nCols = this.getData().getTableConfig().getNcols();
            this.setSize(nRows, nCols);
            List<TableColumn> columns = this.getData().getColumns();
            int iCol = 0;
            for (TableColumn cdata : columns) {
                this.setColumnName(cdata.getIdCol() - 1, cdata.getNombreCol());
                this.setColumnDescription(cdata.getIdCol() - 1, cdata.getTooltip());
                this.setColumnClass(cdata.getIdCol() - 1, String.class);
                int i = 0;
                while (i < nRows) {
                    this.setCellEditable(i, iCol, cdata.getSave());
                    ++i;
                }
                ++iCol;
            }
            int i = 0;
            while (i < nRows) {
                int j = 0;
                while (j < nCols) {
                    this.setValueAt(0, i, j);
                    ++j;
                }
                ++i;
            }
        }
    }

    private void setData(TableData data) {
        this.data = data;
    }

    public TableData getData() {
        return this.data;
    }
}

