/*
 * Decompiled with CFR 0.152.
 */
package ecoSim.data;

import java.util.ArrayList;
import java.util.EventListener;
import java.util.EventObject;
import java.util.List;
import java.util.ListIterator;

public abstract class EventController<T extends EventListener, K extends EventObject> {
    private transient List<T> listeners = new ArrayList<T>();

    public final void addListener(T listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public final void removeListener(T listener) {
        this.listeners.remove(listener);
    }

    protected abstract void notifyListener(T var1, K var2);

    public final void notifyListeners(K event) {
        ListIterator<T> it = this.listeners.listIterator();
        while (it.hasNext()) {
            this.notifyListener((EventListener)it.next(), event);
        }
    }
}

