/*
 * Decompiled with CFR 0.152.
 */
package ecoSim.data;

import ecoSim.data.AbstractEcoSimData;
import ecoSim.data.EventController;
import ecoSim.gui.EcoSimViewTable;
import java.io.Serializable;
import java.util.Arrays;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;

public abstract class DataBlockTableModel
extends EventController<TableModelListener, TableModelEvent>
implements TableModel,
Serializable {
    private static final long serialVersionUID = -6953011410029707259L;
    private Object[][] data;
    private transient Class<?>[] columnClasses;
    private transient String[] columnNames;
    private transient String[] columnDescriptions;
    private transient boolean[][] cellEditable;
    private transient String name;
    private transient AbstractEcoSimData listener;
    private transient EcoSimViewTable view = null;
    private transient String text = null;

    public DataBlockTableModel(String name, AbstractEcoSimData listener) {
        this(name, listener, true);
    }

    public final String getText() {
        return this.text;
    }

    protected final void setText(String text) {
        this.text = text;
    }

    public final EcoSimViewTable getView() {
        return this.view;
    }

    public final void setView(EcoSimViewTable view) {
        this.view = view;
    }

    public DataBlockTableModel(String name, AbstractEcoSimData listener, boolean mustBeSaved) {
        this.name = name;
        if (mustBeSaved) {
            this.addListener(listener);
        }
        this.listener = listener;
        this.clear();
    }

    public AbstractEcoSimData getListener() {
        return this.listener;
    }

    public String getName() {
        return this.name;
    }

    public abstract void clear();

    public void setSize(int rows, int columns) {
        if (rows <= 0) {
            throw new IllegalArgumentException("Rows = " + rows);
        }
        if (columns <= 0) {
            throw new IllegalArgumentException("Columns = " + rows);
        }
        if (rows == this.getRowCount() && columns == this.getColumnCount()) {
            return;
        }
        Object[][] newData = new Object[rows][columns];
        boolean[][] newCellEditable = new boolean[rows][columns];
        Object[] newColumnClasses = new Class[columns];
        Object[] newColumnNames = new String[columns];
        Object[] newColumnDescriptions = new String[columns];
        Arrays.fill(newColumnClasses, Object.class);
        Arrays.fill(newColumnNames, "");
        Arrays.fill(newColumnDescriptions, "");
        if (this.data != null) {
            int j = 0;
            while (j < this.getColumnCount()) {
                int i = 0;
                while (i < this.getRowCount()) {
                    if (i < rows && j < columns) {
                        newData[i][j] = this.data[i][j];
                        newCellEditable[i][j] = this.cellEditable[i][j];
                    }
                    ++i;
                }
                if (j < columns) {
                    newColumnClasses[j] = this.columnClasses[j];
                    newColumnNames[j] = this.columnNames[j];
                    newColumnDescriptions[j] = this.columnDescriptions[j];
                }
                ++j;
            }
        }
        this.data = newData;
        this.cellEditable = newCellEditable;
        this.columnClasses = newColumnClasses;
        this.columnNames = newColumnNames;
        this.columnDescriptions = newColumnDescriptions;
        this.notifyListeners(new TableModelEvent(this, -1));
    }

    @Override
    protected void notifyListener(TableModelListener listener, TableModelEvent event) {
        listener.tableChanged(event);
    }

    @Override
    public void addTableModelListener(TableModelListener l) {
        super.addListener(l);
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return this.columnClasses[columnIndex];
    }

    @Override
    public int getColumnCount() {
        if (this.data == null) {
            return 0;
        }
        return this.data[0].length;
    }

    @Override
    public String getColumnName(int columnIndex) {
        return this.columnNames[columnIndex];
    }

    @Override
    public int getRowCount() {
        if (this.data == null) {
            return 0;
        }
        return this.data.length;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        return this.data[rowIndex][columnIndex];
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return this.cellEditable[rowIndex][columnIndex];
    }

    @Override
    public void removeTableModelListener(TableModelListener l) {
        super.removeListener(l);
    }

    @Override
    public void setValueAt(Object value, int rowIndex, int columnIndex) {
        this.data[rowIndex][columnIndex] = value;
        this.notifyListeners(new TableModelEvent(this, rowIndex, rowIndex, columnIndex));
    }

    public final void notifyListeners() {
        this.notifyListeners(new TableModelEvent(this));
    }

    public final void updateValue(Object value, int rowIndex, int columnIndex) {
        this.data[rowIndex][columnIndex] = value;
    }

    protected void setCellEditable(int rowIndex, int columnIndex, boolean cellEditable) {
        this.cellEditable[rowIndex][columnIndex] = cellEditable;
    }

    protected void setColumnClass(int columnIndex, Class<?> columnClass) {
        this.columnClasses[columnIndex] = columnClass;
        this.notifyListeners(new TableModelEvent(this, -1));
    }

    protected void setColumnName(int columnIndex, String columnName) {
        this.columnNames[columnIndex] = columnName;
        this.notifyListeners(new TableModelEvent(this, -1));
    }

    public String getColumnDescription(int columnIndex) {
        return this.columnDescriptions[columnIndex];
    }

    protected void setColumnDescription(int columnIndex, String columnDescription) {
        this.columnDescriptions[columnIndex] = columnDescription;
    }

    public String getCellName(int rowIndex, int columnIndex) {
        return this.getColumnDescription(columnIndex);
    }

    public abstract void update(boolean var1);
}

