/*
 * Decompiled with CFR 0.152.
 */
package ecoSim.actions;

import ecoSim.actions.AbstractEcoSimAction;
import ecoSim.gui.AbstractEcoSimGUI;
import ecoSim.gui.EcoSimPromptNumber;
import java.awt.Cursor;
import java.io.PrintStream;
import javax.swing.SwingWorker;
import org.gcn.plinguacore.util.PlinguaCoreException;

public class EcoSimSimulateStepsAction
extends AbstractEcoSimAction {
    private static EcoSimSimulateStepsAction singleton = null;

    private EcoSimSimulateStepsAction() {
    }

    public static EcoSimSimulateStepsAction getInstance() {
        if (singleton == null) {
            singleton = new EcoSimSimulateStepsAction();
        }
        return singleton;
    }

    @Override
    protected void doSecureAction(AbstractEcoSimGUI gui) {
        EcoSimPromptNumber prompt = new EcoSimPromptNumber("Number of steps to simulate", 10, Integer.class, gui);
        Number steps = prompt.prompt();
        if (steps != null && steps.intValue() > 0) {
            RunStepsSwingWorker worker = new RunStepsSwingWorker(gui, steps.intValue());
            worker.execute();
        }
    }

    @Override
    public boolean isEnabledAction(AbstractEcoSimGUI gui) {
        return gui.getData().getState() != 4 && gui.getData().getState() != 0 && gui.getData().getPlinguaFile() != null && gui.getData().getSimulator() != null;
    }

    class RunStepsSwingWorker
    extends SwingWorker<Void, Void> {
        private int steps;
        private AbstractEcoSimGUI gui;

        public RunStepsSwingWorker(AbstractEcoSimGUI gui, int steps) {
            this.steps = steps;
            this.gui = gui;
        }

        @Override
        protected Void doInBackground() throws Exception {
            try {
                this.gui.getData().beginSimulationState();
                this.gui.getFrame().setCursor(Cursor.getPredefinedCursor(3));
                this.gui.getData().getSimulator().runSteps(this.steps);
            }
            catch (PlinguaCoreException e) {
                PrintStream ps = this.gui.getPrintStreams().get("Errors");
                if (ps != null) {
                    ps.println(e.getMessage());
                }
                System.out.println(e.getMessage());
            }
            return null;
        }

        @Override
        protected void done() {
            this.gui.getFrame().setCursor(null);
            this.gui.getData().endSimulationState();
            super.done();
        }
    }
}

