/*
 * Decompiled with CFR 0.152.
 */
package ecoSim;

import ecoSim.DAOFacade;
import ecoSim.EcoSimApp;
import ecoSim.SelectApplicationFrm;
import ecoSim.properties.UnavailablePropertyException;

public class Main {
    public static void main(String[] args) {
        if (args != null && args.length > 0 && args[0].equals("enduser")) {
            String[] ars = new String[]{"CE", "3"};
            Main.oldMain(ars);
        } else {
            SelectApplicationFrm.main(args);
        }
    }

    public static void oldMain(String[] args) {
        String app = "";
        if (args.length > 0) {
            app = args[0].toUpperCase();
            if (app.equals("CE")) {
                System.out.println();
                System.out.println();
                System.out.println("Welcome to MeCoSim (Membrane Computing Simulator)");
                System.out.println("------------------------------------------------");
                if (args.length > 1) {
                    String mode = args[1].toUpperCase();
                    if (mode.equals("2")) {
                        DAOFacade.updateModelFromExcel(false, false, true, true, true, true);
                    } else if (mode.equals("3")) {
                        DAOFacade.updateModelFromExcel(false, false, false, false, false, false);
                    } else {
                        DAOFacade.updateModelFromExcel(true, true, true, true, true, true);
                    }
                } else {
                    DAOFacade.updateModelFromExcel(true, true, true, true, true, true);
                }
            }
        } else {
            DAOFacade.updateModelFromExcel(true, true, true, true, true, true);
            try {
                app = DAOFacade.getProperty("default-app");
            }
            catch (UnavailablePropertyException e) {
                Main.printHelp();
            }
        }
        try {
            System.out.println();
            System.out.println("Loading main window...");
            EcoSimApp.runApp(app, true);
        }
        catch (UnavailablePropertyException e) {
            Main.printHelp();
        }
    }

    public static void printHelp() {
        System.out.println("Please, use the next format to run ECO-SIM:");
        System.out.println();
        System.out.println("java -jar -Xmx[memory]m ecosim.jar [option]");
        System.out.println();
        System.out.println("Where:");
        System.out.println("[memory] is the amount of RAM memory to use (in megabytes). It is recomended to use a number >=2048");
        System.out.println("[option] is a word to indicate the ecosystem to simulate");
        System.out.println();
        System.out.println("Allowed values for [option]: ");
        System.out.println("ce: Run EcoSim for Custom Ecosystem");
        System.out.println();
        System.out.println("Examples:");
        System.out.println("java -jar -Xmx2048m ecosim.jar ce");
    }
}

